'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTreeNavigation", {
    enumerable: true,
    get: function() {
        return useTreeNavigation;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _nextTypeAheadElement = require("../utils/nextTypeAheadElement");
const _tokens = require("../utils/tokens");
const _useRovingTabIndexes = require("./useRovingTabIndexes");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useHTMLElementWalkerRef = require("./useHTMLElementWalkerRef");
const _reactutilities = require("@fluentui/react-utilities");
const _TreeItemLayout = require("../TreeItemLayout");
const _reacttabster = require("@fluentui/react-tabster");
function useTreeNavigation(navigationMode = 'tree') {
    'use no memo';
    const { rove, initialize: initializeRovingTabIndex, forceUpdate: forceUpdateRovingTabIndex } = (0, _useRovingTabIndexes.useRovingTabIndex)();
    const { findFirstFocusable } = (0, _reacttabster.useFocusFinders)();
    const { walkerRef, rootRef: walkerRootRef } = (0, _useHTMLElementWalkerRef.useHTMLElementWalkerRef)();
    const rootRefCallback = _react.useCallback((root)=>{
        if (root && walkerRef.current) {
            initializeRovingTabIndex(walkerRef.current);
        }
    }, [
        walkerRef,
        initializeRovingTabIndex
    ]);
    const getNextElement = (data)=>{
        if (!walkerRef.current) {
            return null;
        }
        switch(data.type){
            case _tokens.treeDataTypes.Click:
                return data.target;
            case _tokens.treeDataTypes.TypeAhead:
                walkerRef.current.currentElement = data.target;
                return (0, _nextTypeAheadElement.nextTypeAheadElement)(walkerRef.current, data.event.key);
            case _tokens.treeDataTypes.ArrowLeft:
                {
                    const actions = queryActions(data.target);
                    if (navigationMode === 'treegrid' && (actions === null || actions === void 0 ? void 0 : actions.contains(data.target.ownerDocument.activeElement))) {
                        return data.target;
                    }
                    walkerRef.current.currentElement = data.target;
                    return walkerRef.current.parentElement();
                }
            case _tokens.treeDataTypes.ArrowRight:
                if (navigationMode === 'treegrid') {
                    const actions = queryActions(data.target);
                    if (actions) {
                        var _findFirstFocusable;
                        (_findFirstFocusable = findFirstFocusable(actions)) === null || _findFirstFocusable === void 0 ? void 0 : _findFirstFocusable.focus();
                    }
                    return null;
                }
                walkerRef.current.currentElement = data.target;
                return walkerRef.current.firstChild();
            case _tokens.treeDataTypes.End:
                walkerRef.current.currentElement = walkerRef.current.root;
                return lastChildRecursive(walkerRef.current);
            case _tokens.treeDataTypes.Home:
                walkerRef.current.currentElement = walkerRef.current.root;
                return walkerRef.current.firstChild();
            case _tokens.treeDataTypes.ArrowDown:
                walkerRef.current.currentElement = data.target;
                return walkerRef.current.nextElement();
            case _tokens.treeDataTypes.ArrowUp:
                walkerRef.current.currentElement = data.target;
                return walkerRef.current.previousElement();
        }
    };
    function navigate(data, focusOptions) {
        const nextElement = getNextElement(data);
        if (nextElement) {
            rove(nextElement, focusOptions);
        }
        return nextElement;
    }
    return {
        navigate,
        treeRef: (0, _reactutilities.useMergedRefs)(walkerRootRef, rootRefCallback),
        forceUpdateRovingTabIndex
    };
}
function lastChildRecursive(walker) {
    let lastElement = null;
    let nextElement = null;
    while(nextElement = walker.lastChild()){
        lastElement = nextElement;
    }
    return lastElement;
}
const queryActions = (target)=>target.querySelector(`:scope > .${_TreeItemLayout.treeItemLayoutClassNames.root} > .${_TreeItemLayout.treeItemLayoutClassNames.actions}`);
