'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSubtree", {
    enumerable: true,
    get: function() {
        return useSubtree;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _index = require("../contexts/index");
const _reactutilities = require("@fluentui/react-utilities");
const _reactmotioncomponentspreview = require("@fluentui/react-motion-components-preview");
const _reactmotion = require("@fluentui/react-motion");
function useSubtree(props, ref) {
    const subtreeRef = (0, _index.useTreeItemContext_unstable)((ctx)=>ctx.subtreeRef);
    const { level: parentLevel } = (0, _index.useSubtreeContext_unstable)();
    const open = (0, _index.useTreeItemContext_unstable)((ctx)=>ctx.open);
    return {
        contextType: 'subtree',
        open,
        components: {
            root: 'div',
            collapseMotion: _reactmotioncomponentspreview.Collapse
        },
        level: parentLevel + 1,
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, subtreeRef),
            role: 'group',
            ...props
        }), {
            elementType: 'div'
        }),
        collapseMotion: (0, _reactmotion.presenceMotionSlot)(props.collapseMotion, {
            elementType: _reactmotioncomponentspreview.Collapse,
            defaultProps: {
                visible: open,
                unmountOnExit: true
            }
        })
    };
}
