'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useRovingTabIndex", {
    enumerable: true,
    get: function() {
        return useRovingTabIndex;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reacttabster = require("@fluentui/react-tabster");
const findTreeItemRoot = (element)=>{
    let parent = element.parentElement;
    while(parent && parent.getAttribute('role') !== 'tree'){
        parent = parent.parentElement;
    }
    return parent;
};
function useRovingTabIndex() {
    const currentElementRef = _react.useRef(null);
    const walkerRef = _react.useRef(null);
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    (0, _reacttabster.useFocusedElementChange)((element)=>{
        if ((element === null || element === void 0 ? void 0 : element.getAttribute('role')) === 'treeitem' && walkerRef.current && walkerRef.current.root.contains(element)) {
            const treeitemRoot = findTreeItemRoot(element);
            if (walkerRef.current.root !== treeitemRoot) {
                return;
            }
            rove(element);
        }
    });
    const initialize = _react.useCallback((walker)=>{
        walkerRef.current = walker;
        walker.currentElement = walker.root;
        let tabbableChild = walker.firstChild((element)=>element.tabIndex === 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP);
        walker.currentElement = walker.root;
        tabbableChild !== null && tabbableChild !== void 0 ? tabbableChild : tabbableChild = walker.firstChild();
        if (!tabbableChild) {
            return;
        }
        tabbableChild.tabIndex = 0;
        currentElementRef.current = tabbableChild;
        let nextElement = null;
        while((nextElement = walker.nextElement()) && nextElement !== tabbableChild){
            nextElement.tabIndex = -1;
        }
    }, []);
    const rove = _react.useCallback((nextElement, focusOptions)=>{
        if (!currentElementRef.current) {
            return;
        }
        currentElementRef.current.tabIndex = -1;
        nextElement.tabIndex = 0;
        nextElement.focus(focusOptions);
        currentElementRef.current = nextElement;
    }, []);
    const forceUpdate = _react.useCallback(()=>{
        if ((currentElementRef.current === null || !(targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.body.contains(currentElementRef.current))) && walkerRef.current) {
            initialize(walkerRef.current);
        }
    }, [
        targetDocument,
        initialize
    ]);
    return {
        rove,
        initialize,
        forceUpdate
    };
}
