'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useRootTree", {
    enumerable: true,
    get: function() {
        return useRootTree;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactmotioncomponentspreview = require("@fluentui/react-motion-components-preview");
const _createCheckedItems = require("../utils/createCheckedItems");
const _tokens = require("../utils/tokens");
const _useControllableOpenItems = require("./useControllableOpenItems");
const _ImmutableSet = require("../utils/ImmutableSet");
const _ImmutableMap = require("../utils/ImmutableMap");
function useRootTree(props, ref) {
    warnIfNoProperPropsRootTree(props);
    const { appearance = 'subtle', size = 'medium', selectionMode = 'none' } = props;
    const openItems = _react.useMemo(()=>_ImmutableSet.ImmutableSet.from(props.openItems), [
        props.openItems
    ]);
    const checkedItems = _react.useMemo(()=>(0, _createCheckedItems.createCheckedItems)(props.checkedItems), [
        props.checkedItems
    ]);
    const requestOpenChange = (request)=>{
        var _props_onOpenChange;
        (_props_onOpenChange = props.onOpenChange) === null || _props_onOpenChange === void 0 ? void 0 : _props_onOpenChange.call(props, request.event, {
            ...request,
            openItems: _ImmutableSet.ImmutableSet.dangerouslyGetInternalSet((0, _useControllableOpenItems.createNextOpenItems)(request, openItems))
        });
    };
    const requestCheckedChange = (request)=>{
        var _props_onCheckedChange;
        if (selectionMode === 'none') {
            return;
        }
        (_props_onCheckedChange = props.onCheckedChange) === null || _props_onCheckedChange === void 0 ? void 0 : _props_onCheckedChange.call(props, request.event, {
            ...request,
            selectionMode,
            checkedItems: _ImmutableMap.ImmutableMap.dangerouslyGetInternalMap(checkedItems)
        });
    };
    const requestNavigation = (request)=>{
        var _props_onNavigation;
        let isScrollPrevented = false;
        (_props_onNavigation = props.onNavigation) === null || _props_onNavigation === void 0 ? void 0 : _props_onNavigation.call(props, request.event, {
            ...request,
            preventScroll: ()=>{
                isScrollPrevented = true;
            },
            isScrollPrevented: ()=>isScrollPrevented
        });
        switch(request.type){
            case _tokens.treeDataTypes.ArrowDown:
            case _tokens.treeDataTypes.ArrowUp:
            case _tokens.treeDataTypes.Home:
            case _tokens.treeDataTypes.End:
                // stop the default behavior of the event
                // which is to scroll the page
                request.event.preventDefault();
        }
    };
    const requestTreeResponse = (0, _reactutilities.useEventCallback)((request)=>{
        switch(request.requestType){
            case 'navigate':
                return requestNavigation(request);
            case 'open':
                return requestOpenChange(request);
            case 'selection':
                return requestCheckedChange(request);
        }
    });
    var _props_navigationMode;
    return {
        components: {
            root: 'div',
            collapseMotion: _reactmotioncomponentspreview.Collapse
        },
        contextType: 'root',
        selectionMode,
        navigationMode: (_props_navigationMode = props.navigationMode) !== null && _props_navigationMode !== void 0 ? _props_navigationMode : 'tree',
        open: true,
        appearance,
        size,
        level: 1,
        openItems,
        checkedItems,
        requestTreeResponse,
        forceUpdateRovingTabIndex: ()=>{
        // noop
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref,
            role: 'tree',
            'aria-multiselectable': selectionMode === 'multiselect' ? true : undefined,
            ...props
        }), {
            elementType: 'div'
        }),
        collapseMotion: undefined
    };
}
function warnIfNoProperPropsRootTree(props) {
    if (process.env.NODE_ENV === 'development') {
        if (!props['aria-label'] && !props['aria-labelledby']) {
            // eslint-disable-next-line no-console
            console.warn(`@fluentui/react-tree [useRootTree]:
Tree must have either a \`aria-label\` or \`aria-labelledby\` property defined`);
        }
    }
}
