'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useHTMLElementWalkerRef", {
    enumerable: true,
    get: function() {
        return useHTMLElementWalkerRef;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _createHTMLElementWalker = require("../utils/createHTMLElementWalker");
const _treeItemFilter = require("../utils/treeItemFilter");
function useHTMLElementWalkerRef() {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const walkerRef = _react.useRef(undefined);
    const rootRef = _react.useCallback((root)=>{
        walkerRef.current = targetDocument && root ? (0, _createHTMLElementWalker.createHTMLElementWalker)(root, targetDocument, _treeItemFilter.treeItemFilter) : undefined;
    }, [
        targetDocument
    ]);
    return {
        walkerRef,
        rootRef
    };
}
