'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createNextOpenItems: function() {
        return createNextOpenItems;
    },
    useControllableOpenItems: function() {
        return useControllableOpenItems;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _ImmutableSet = require("../utils/ImmutableSet");
function useControllableOpenItems(props) {
    return (0, _reactutilities.useControllableState)({
        state: _react.useMemo(()=>props.openItems && _ImmutableSet.ImmutableSet.from(props.openItems), [
            props.openItems
        ]),
        defaultState: props.defaultOpenItems && (()=>_ImmutableSet.ImmutableSet.from(props.defaultOpenItems)),
        initialState: _ImmutableSet.ImmutableSet.empty
    });
}
function createNextOpenItems(data, previousOpenItems) {
    return data.open ? previousOpenItems.add(data.value) : previousOpenItems.delete(data.value);
}
