'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    treeItemPersonaLayoutClassNames: function() {
        return treeItemPersonaLayoutClassNames;
    },
    useTreeItemPersonaLayoutStyles_unstable: function() {
        return useTreeItemPersonaLayoutStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _tokens = require("../../utils/tokens");
const _treeItemContext = require("../../contexts/treeItemContext");
const treeItemPersonaLayoutClassNames = {
    root: 'fui-TreeItemPersonaLayout',
    media: 'fui-TreeItemPersonaLayout__media',
    description: 'fui-TreeItemPersonaLayout__description',
    main: 'fui-TreeItemPersonaLayout__main',
    expandIcon: 'fui-TreeItemPersonaLayout__expandIcon',
    aside: 'fui-TreeItemPersonaLayout__aside',
    actions: 'fui-TreeItemPersonaLayout__actions',
    selector: 'fui-TreeItemPersonaLayout__selector'
};
const useRootBaseStyles = (0, _react.makeResetStyles)({
    display: 'grid',
    gridTemplateRows: '1fr auto',
    gridTemplateColumns: 'auto auto 1fr auto',
    gridTemplateAreas: `
    "expandIcon media main        aside"
    "expandIcon media description aside"
  `,
    alignItems: 'center',
    ..._reacttheme.typographyStyles.body1,
    ':active': {
        color: _reacttheme.tokens.colorNeutralForeground2Pressed,
        backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed,
        // TODO: stop using treeItemPersonaLayoutClassNames.expandIcon for styling
        [`& .${treeItemPersonaLayoutClassNames.expandIcon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground3Pressed
        }
    },
    ':hover': {
        color: _reacttheme.tokens.colorNeutralForeground2Hover,
        backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover,
        // TODO: stop using treeItemPersonaLayoutClassNames.expandIcon  for styling
        [`& .${treeItemPersonaLayoutClassNames.expandIcon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground3Hover
        }
    }
});
/**
 * Styles for the root slot
 */ const useRootStyles = (0, _react.makeStyles)({
    leaf: {
        paddingLeft: `calc(var(${_tokens.treeItemLevelToken}, 1) * ${_reacttheme.tokens.spacingHorizontalXXL})`
    },
    branch: {
        paddingLeft: `calc((var(${_tokens.treeItemLevelToken}, 1) - 1) * ${_reacttheme.tokens.spacingHorizontalXXL})`
    }
});
/**
 * Styles for the expand icon slot
 */ const useMediaBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    alignItems: 'center',
    width: '32px',
    height: '32px',
    gridArea: 'media',
    padding: `0 ${_reacttheme.tokens.spacingHorizontalXS} 0 ${_reacttheme.tokens.spacingHorizontalXXS}`
});
const useMainBaseStyles = (0, _react.makeResetStyles)({
    gridArea: 'main',
    padding: `${_reacttheme.tokens.spacingVerticalMNudge} ${_reacttheme.tokens.spacingHorizontalXS} ${_reacttheme.tokens.spacingVerticalMNudge} ${_reacttheme.tokens.spacingHorizontalS}`
});
const useMainStyles = (0, _react.makeStyles)({
    withDescription: {
        padding: `${_reacttheme.tokens.spacingVerticalMNudge} ${_reacttheme.tokens.spacingHorizontalXS} 0 ${_reacttheme.tokens.spacingHorizontalS}`
    }
});
const useDescriptionBaseStyles = (0, _react.makeResetStyles)({
    gridArea: 'description',
    ..._reacttheme.typographyStyles.caption1,
    padding: `0 ${_reacttheme.tokens.spacingHorizontalXS} ${_reacttheme.tokens.spacingVerticalMNudge} ${_reacttheme.tokens.spacingHorizontalS}`
});
/**
 * Styles for the action icon slot
 */ const useActionsBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    marginLeft: 'auto',
    position: 'relative',
    zIndex: 1,
    gridArea: 'aside',
    padding: `0 ${_reacttheme.tokens.spacingHorizontalS}`
});
/**
 * Styles for the action icon slot
 */ const useAsideBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    marginLeft: 'auto',
    alignItems: 'center',
    zIndex: 0,
    gridArea: 'aside',
    padding: `0 ${_reacttheme.tokens.spacingHorizontalM}`,
    gap: _reacttheme.tokens.spacingHorizontalXS
});
/**
 * Styles for the expand icon slot
 */ const useExpandIconBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    minWidth: '24px',
    boxSizing: 'border-box',
    color: _reacttheme.tokens.colorNeutralForeground3,
    gridArea: 'expandIcon',
    flex: `0 0 auto`,
    padding: `${_reacttheme.tokens.spacingVerticalXS} 0`
});
const useTreeItemPersonaLayoutStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyles = useRootBaseStyles();
    const rootStyles = useRootStyles();
    const mediaBaseStyles = useMediaBaseStyles();
    const descriptionBaseStyles = useDescriptionBaseStyles();
    const actionsBaseStyles = useActionsBaseStyles();
    const asideBaseStyles = useAsideBaseStyles();
    const expandIconBaseStyles = useExpandIconBaseStyles();
    const mainBaseStyles = useMainBaseStyles();
    const mainStyles = useMainStyles();
    const itemType = (0, _treeItemContext.useTreeItemContext_unstable)((ctx)=>ctx.itemType);
    state.root.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.root, rootBaseStyles, rootStyles[itemType], state.root.className);
    state.media.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.media, mediaBaseStyles, state.media.className);
    if (state.main) {
        state.main.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.main, mainBaseStyles, state.description && mainStyles.withDescription, state.main.className);
    }
    if (state.description) {
        state.description.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.description, descriptionBaseStyles, state.description.className);
    }
    if (state.actions) {
        state.actions.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.actions, actionsBaseStyles, state.actions.className);
    }
    if (state.aside) {
        state.aside.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.aside, asideBaseStyles, state.aside.className);
    }
    if (state.expandIcon) {
        state.expandIcon.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.expandIcon, expandIconBaseStyles, state.expandIcon.className);
    }
    if (state.selector) {
        state.selector.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.selector, state.selector.className);
    }
    return state;
};
