'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    treeItemPersonaLayoutClassNames: function() {
        return treeItemPersonaLayoutClassNames;
    },
    useTreeItemPersonaLayoutStyles_unstable: function() {
        return useTreeItemPersonaLayoutStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _treeItemContext = require("../../contexts/treeItemContext");
const treeItemPersonaLayoutClassNames = {
    root: 'fui-TreeItemPersonaLayout',
    media: 'fui-TreeItemPersonaLayout__media',
    description: 'fui-TreeItemPersonaLayout__description',
    main: 'fui-TreeItemPersonaLayout__main',
    expandIcon: 'fui-TreeItemPersonaLayout__expandIcon',
    aside: 'fui-TreeItemPersonaLayout__aside',
    actions: 'fui-TreeItemPersonaLayout__actions',
    selector: 'fui-TreeItemPersonaLayout__selector'
};
const useRootBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1r98egg", null, [
    ".r1r98egg{display:grid;grid-template-rows:1fr auto;grid-template-columns:auto auto 1fr auto;grid-template-areas:\"expandIcon media main        aside\" \"expandIcon media description aside\";align-items:center;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase300);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);}",
    ".r1r98egg:active{color:var(--colorNeutralForeground2Pressed);background-color:var(--colorSubtleBackgroundPressed);}",
    ".r1r98egg:active .fui-TreeItemPersonaLayout__expandIcon{color:var(--colorNeutralForeground3Pressed);}",
    ".r1r98egg:hover{color:var(--colorNeutralForeground2Hover);background-color:var(--colorSubtleBackgroundHover);}",
    ".r1r98egg:hover .fui-TreeItemPersonaLayout__expandIcon{color:var(--colorNeutralForeground3Hover);}"
]);
/**
 * Styles for the root slot
 */ const useRootStyles = /*#__PURE__*/ (0, _react.__styles)({
    leaf: {
        uwmqm3: [
            "f1k1erfc",
            "faevyjx"
        ]
    },
    branch: {
        uwmqm3: [
            "fo100m9",
            "f6yw3pu"
        ]
    }
}, {
    d: [
        ".f1k1erfc{padding-left:calc(var(--fluent-TreeItem--level, 1) * var(--spacingHorizontalXXL));}",
        ".faevyjx{padding-right:calc(var(--fluent-TreeItem--level, 1) * var(--spacingHorizontalXXL));}",
        ".fo100m9{padding-left:calc((var(--fluent-TreeItem--level, 1) - 1) * var(--spacingHorizontalXXL));}",
        ".f6yw3pu{padding-right:calc((var(--fluent-TreeItem--level, 1) - 1) * var(--spacingHorizontalXXL));}"
    ]
});
/**
 * Styles for the expand icon slot
 */ const useMediaBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rkcde6g", "r1e986zr", [
    ".rkcde6g{display:flex;align-items:center;width:32px;height:32px;grid-area:media;padding:0 var(--spacingHorizontalXS) 0 var(--spacingHorizontalXXS);}",
    ".r1e986zr{display:flex;align-items:center;width:32px;height:32px;grid-area:media;padding:0 var(--spacingHorizontalXXS) 0 var(--spacingHorizontalXS);}"
]);
const useMainBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1qjtz99", "rob5fcp", [
    ".r1qjtz99{grid-area:main;padding:var(--spacingVerticalMNudge) var(--spacingHorizontalXS) var(--spacingVerticalMNudge) var(--spacingHorizontalS);}",
    ".rob5fcp{grid-area:main;padding:var(--spacingVerticalMNudge) var(--spacingHorizontalS) var(--spacingVerticalMNudge) var(--spacingHorizontalXS);}"
]);
const useMainStyles = /*#__PURE__*/ (0, _react.__styles)({
    withDescription: {
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: [
            "f1625emv",
            "f5y9hxg"
        ]
    }
}, {
    d: [
        [
            ".f1625emv{padding:var(--spacingVerticalMNudge) var(--spacingHorizontalXS) 0 var(--spacingHorizontalS);}",
            {
                p: -1
            }
        ],
        [
            ".f5y9hxg{padding:var(--spacingVerticalMNudge) var(--spacingHorizontalS) 0 var(--spacingHorizontalXS);}",
            {
                p: -1
            }
        ]
    ]
});
const useDescriptionBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1bnsn1b", "r13x7gq", [
    ".r1bnsn1b{grid-area:description;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase200);padding:0 var(--spacingHorizontalXS) var(--spacingVerticalMNudge) var(--spacingHorizontalS);}",
    ".r13x7gq{grid-area:description;font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase200);padding:0 var(--spacingHorizontalS) var(--spacingVerticalMNudge) var(--spacingHorizontalXS);}"
]);
/**
 * Styles for the action icon slot
 */ const useActionsBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rzvs2in", "r17h8a29", [
    ".rzvs2in{display:flex;margin-left:auto;position:relative;z-index:1;grid-area:aside;padding:0 var(--spacingHorizontalS);}",
    ".r17h8a29{display:flex;margin-right:auto;position:relative;z-index:1;grid-area:aside;padding:0 var(--spacingHorizontalS);}"
]);
/**
 * Styles for the action icon slot
 */ const useAsideBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1825u21", "rezy0yk", [
    ".r1825u21{display:flex;margin-left:auto;align-items:center;z-index:0;grid-area:aside;padding:0 var(--spacingHorizontalM);gap:var(--spacingHorizontalXS);}",
    ".rezy0yk{display:flex;margin-right:auto;align-items:center;z-index:0;grid-area:aside;padding:0 var(--spacingHorizontalM);gap:var(--spacingHorizontalXS);}"
]);
/**
 * Styles for the expand icon slot
 */ const useExpandIconBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rn61xvs", null, [
    ".rn61xvs{display:flex;align-items:center;justify-content:center;min-width:24px;box-sizing:border-box;color:var(--colorNeutralForeground3);grid-area:expandIcon;flex:0 0 auto;padding:var(--spacingVerticalXS) 0;}"
]);
const useTreeItemPersonaLayoutStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseStyles = useRootBaseStyles();
    const rootStyles = useRootStyles();
    const mediaBaseStyles = useMediaBaseStyles();
    const descriptionBaseStyles = useDescriptionBaseStyles();
    const actionsBaseStyles = useActionsBaseStyles();
    const asideBaseStyles = useAsideBaseStyles();
    const expandIconBaseStyles = useExpandIconBaseStyles();
    const mainBaseStyles = useMainBaseStyles();
    const mainStyles = useMainStyles();
    const itemType = (0, _treeItemContext.useTreeItemContext_unstable)((ctx)=>ctx.itemType);
    state.root.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.root, rootBaseStyles, rootStyles[itemType], state.root.className);
    state.media.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.media, mediaBaseStyles, state.media.className);
    if (state.main) {
        state.main.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.main, mainBaseStyles, state.description && mainStyles.withDescription, state.main.className);
    }
    if (state.description) {
        state.description.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.description, descriptionBaseStyles, state.description.className);
    }
    if (state.actions) {
        state.actions.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.actions, actionsBaseStyles, state.actions.className);
    }
    if (state.aside) {
        state.aside.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.aside, asideBaseStyles, state.aside.className);
    }
    if (state.expandIcon) {
        state.expandIcon.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.expandIcon, expandIconBaseStyles, state.expandIcon.className);
    }
    if (state.selector) {
        state.selector.className = (0, _react.mergeClasses)(treeItemPersonaLayoutClassNames.selector, state.selector.className);
    }
    return state;
};
