'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTreeItemPersonaLayout_unstable", {
    enumerable: true,
    get: function() {
        return useTreeItemPersonaLayout_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _contexts = require("../../contexts");
const _tokens = require("../../utils/tokens");
const _useTreeItemLayout = require("../TreeItemLayout/useTreeItemLayout");
const _reactcheckbox = require("@fluentui/react-checkbox");
const _reactradio = require("@fluentui/react-radio");
const useTreeItemPersonaLayout_unstable = (props, ref)=>{
    const { media, children, main, description } = props;
    const treeItemLayoutState = (0, _useTreeItemLayout.useTreeItemLayout_unstable)({
        ...props,
        iconBefore: null,
        iconAfter: null
    }, ref);
    const size = (0, _contexts.useTreeContext_unstable)((ctx)=>ctx.size);
    const selectionMode = (0, _contexts.useTreeContext_unstable)((ctx)=>ctx.selectionMode);
    return {
        ...treeItemLayoutState,
        components: {
            expandIcon: 'div',
            main: 'div',
            description: 'div',
            root: 'div',
            media: 'div',
            aside: 'div',
            actions: 'div',
            // Casting here to a union between checkbox and radio
            selector: selectionMode === 'multiselect' ? _reactcheckbox.Checkbox : _reactradio.Radio
        },
        avatarSize: _tokens.treeAvatarSize[size],
        main: _reactutilities.slot.always(main, {
            defaultProps: {
                children
            },
            elementType: 'div'
        }),
        media: _reactutilities.slot.always(media, {
            elementType: 'div'
        }),
        description: _reactutilities.slot.optional(description, {
            elementType: 'div'
        })
    };
};
