'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    treeItemLayoutClassNames: function() {
        return treeItemLayoutClassNames;
    },
    useTreeItemLayoutStyles_unstable: function() {
        return useTreeItemLayoutStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _treeContext = require("../../contexts/treeContext");
const _tokens = require("../../utils/tokens");
const _treeItemContext = require("../../contexts/treeItemContext");
const treeItemLayoutClassNames = {
    root: 'fui-TreeItemLayout',
    iconBefore: 'fui-TreeItemLayout__iconBefore',
    main: 'fui-TreeItemLayout__main',
    iconAfter: 'fui-TreeItemLayout__iconAfter',
    expandIcon: 'fui-TreeItemLayout__expandIcon',
    aside: 'fui-TreeItemLayout__aside',
    actions: 'fui-TreeItemLayout__actions',
    selector: 'fui-TreeItemLayout__selector'
};
const useRootBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    alignItems: 'center',
    minHeight: '32px',
    boxSizing: 'border-box',
    gridArea: 'layout',
    ':hover': {
        color: _reacttheme.tokens.colorNeutralForeground2Hover,
        backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover,
        // TODO: stop using treeItemLayoutClassNames.expandIcon  for styling
        [`& .${treeItemLayoutClassNames.expandIcon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground3Hover
        }
    },
    ':active': {
        color: _reacttheme.tokens.colorNeutralForeground2Pressed,
        backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed,
        // TODO: stop using treeItemLayoutClassNames.expandIcon for styling
        [`& .${treeItemLayoutClassNames.expandIcon}`]: {
            color: _reacttheme.tokens.colorNeutralForeground3Pressed
        }
    }
});
/**
 * Styles for the root slot
 */ const useRootStyles = (0, _react.makeStyles)({
    leaf: {
        paddingLeft: `calc(var(${_tokens.treeItemLevelToken}, 1) * ${_reacttheme.tokens.spacingHorizontalXXL})`
    },
    branch: {
        paddingLeft: `calc((var(${_tokens.treeItemLevelToken}, 1) - 1) * ${_reacttheme.tokens.spacingHorizontalXXL})`
    },
    medium: {
        ..._reacttheme.typographyStyles.body1
    },
    small: {
        minHeight: '24px',
        ..._reacttheme.typographyStyles.caption1
    },
    // Appearance variations
    subtle: {},
    'subtle-alpha': {
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundLightAlphaHover
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundLightAlphaPressed
        }
    },
    transparent: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundHover
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundPressed
        }
    }
});
/**
 * Styles for the action icon slot
 */ const useActionsBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    marginLeft: 'auto',
    position: 'relative',
    zIndex: 1,
    gridArea: 'aside',
    padding: `0 ${_reacttheme.tokens.spacingHorizontalS}`
});
/**
 * Styles for the action icon slot
 */ const useAsideBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    marginLeft: 'auto',
    alignItems: 'center',
    zIndex: 0,
    gridArea: 'aside',
    padding: `0 ${_reacttheme.tokens.spacingHorizontalM}`,
    gap: _reacttheme.tokens.spacingHorizontalXS
});
/**
 * Styles for the expand icon slot
 */ const useExpandIconBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    minWidth: '24px',
    boxSizing: 'border-box',
    color: _reacttheme.tokens.colorNeutralForeground3,
    flex: `0 0 auto`,
    padding: `${_reacttheme.tokens.spacingVerticalXS} 0`
});
/**
 * Styles for the content slot
 */ const useMainBaseStyles = (0, _react.makeResetStyles)({
    padding: `0 ${_reacttheme.tokens.spacingHorizontalXXS}`
});
/**
 * Styles for the before/after icon slot
 */ const useIconBaseStyles = (0, _react.makeResetStyles)({
    display: 'flex',
    alignItems: 'center',
    color: _reacttheme.tokens.colorNeutralForeground2,
    lineHeight: _reacttheme.tokens.lineHeightBase500,
    fontSize: _reacttheme.tokens.fontSizeBase500
});
const useIconBeforeStyles = (0, _react.makeStyles)({
    medium: {
        paddingRight: _reacttheme.tokens.spacingHorizontalXS
    },
    small: {
        paddingRight: _reacttheme.tokens.spacingHorizontalXXS
    }
});
const useIconAfterStyles = (0, _react.makeStyles)({
    medium: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalXS
    },
    small: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalXXS
    }
});
const useTreeItemLayoutStyles_unstable = (state)=>{
    'use no memo';
    const { main, iconAfter, iconBefore, expandIcon, root, aside, actions, selector } = state;
    const rootStyles = useRootStyles();
    const rootBaseStyles = useRootBaseStyles();
    const actionsBaseStyles = useActionsBaseStyles();
    const asideBaseStyles = useAsideBaseStyles();
    const mainBaseStyles = useMainBaseStyles();
    const expandIconBaseStyles = useExpandIconBaseStyles();
    const iconBaseStyles = useIconBaseStyles();
    const iconBeforeStyles = useIconBeforeStyles();
    const iconAfterStyles = useIconAfterStyles();
    const size = (0, _treeContext.useTreeContext_unstable)((ctx)=>ctx.size);
    const appearance = (0, _treeContext.useTreeContext_unstable)((ctx)=>ctx.appearance);
    const itemType = (0, _treeItemContext.useTreeItemContext_unstable)((ctx)=>ctx.itemType);
    root.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.root, rootBaseStyles, rootStyles[appearance], rootStyles[size], rootStyles[itemType], root.className);
    main.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.main, mainBaseStyles, main.className);
    if (expandIcon) {
        expandIcon.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.expandIcon, expandIconBaseStyles, expandIcon.className);
    }
    if (iconBefore) {
        iconBefore.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.iconBefore, iconBaseStyles, iconBeforeStyles[size], iconBefore.className);
    }
    if (iconAfter) {
        iconAfter.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.iconAfter, iconBaseStyles, iconAfterStyles[size], iconAfter.className);
    }
    if (actions) {
        actions.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.actions, actionsBaseStyles, actions.className);
    }
    if (aside) {
        aside.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.aside, asideBaseStyles, aside.className);
    }
    if (selector) {
        selector.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.selector, selector.className);
    }
    return state;
};
