'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    treeItemLayoutClassNames: function() {
        return treeItemLayoutClassNames;
    },
    useTreeItemLayoutStyles_unstable: function() {
        return useTreeItemLayoutStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _treeContext = require("../../contexts/treeContext");
const _treeItemContext = require("../../contexts/treeItemContext");
const treeItemLayoutClassNames = {
    root: 'fui-TreeItemLayout',
    iconBefore: 'fui-TreeItemLayout__iconBefore',
    main: 'fui-TreeItemLayout__main',
    iconAfter: 'fui-TreeItemLayout__iconAfter',
    expandIcon: 'fui-TreeItemLayout__expandIcon',
    aside: 'fui-TreeItemLayout__aside',
    actions: 'fui-TreeItemLayout__actions',
    selector: 'fui-TreeItemLayout__selector'
};
const useRootBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("ryb8khq", null, [
    ".ryb8khq{display:flex;align-items:center;min-height:32px;box-sizing:border-box;grid-area:layout;}",
    ".ryb8khq:hover{color:var(--colorNeutralForeground2Hover);background-color:var(--colorSubtleBackgroundHover);}",
    ".ryb8khq:hover .fui-TreeItemLayout__expandIcon{color:var(--colorNeutralForeground3Hover);}",
    ".ryb8khq:active{color:var(--colorNeutralForeground2Pressed);background-color:var(--colorSubtleBackgroundPressed);}",
    ".ryb8khq:active .fui-TreeItemLayout__expandIcon{color:var(--colorNeutralForeground3Pressed);}"
]);
/**
 * Styles for the root slot
 */ const useRootStyles = /*#__PURE__*/ (0, _react.__styles)({
    leaf: {
        uwmqm3: [
            "f1k1erfc",
            "faevyjx"
        ]
    },
    branch: {
        uwmqm3: [
            "fo100m9",
            "f6yw3pu"
        ]
    },
    medium: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fkhj508",
        Bhrd7zp: "figsok6",
        Bg96gwp: "f1i3iumi"
    },
    small: {
        sshi5w: "f1pha7fy",
        Bahqtrf: "fk6fouc",
        Be2twd7: "fy9rknc",
        Bhrd7zp: "figsok6",
        Bg96gwp: "fwrc4pm"
    },
    subtle: {},
    "subtle-alpha": {
        Jwef8y: "f146ro5n",
        ecr2s2: "fkam630"
    },
    transparent: {
        De3pzq: "f1c21dwh",
        Jwef8y: "fjxutwb",
        ecr2s2: "fophhak"
    }
}, {
    d: [
        ".f1k1erfc{padding-left:calc(var(--fluent-TreeItem--level, 1) * var(--spacingHorizontalXXL));}",
        ".faevyjx{padding-right:calc(var(--fluent-TreeItem--level, 1) * var(--spacingHorizontalXXL));}",
        ".fo100m9{padding-left:calc((var(--fluent-TreeItem--level, 1) - 1) * var(--spacingHorizontalXXL));}",
        ".f6yw3pu{padding-right:calc((var(--fluent-TreeItem--level, 1) - 1) * var(--spacingHorizontalXXL));}",
        ".fk6fouc{font-family:var(--fontFamilyBase);}",
        ".fkhj508{font-size:var(--fontSizeBase300);}",
        ".figsok6{font-weight:var(--fontWeightRegular);}",
        ".f1i3iumi{line-height:var(--lineHeightBase300);}",
        ".f1pha7fy{min-height:24px;}",
        ".fy9rknc{font-size:var(--fontSizeBase200);}",
        ".fwrc4pm{line-height:var(--lineHeightBase200);}",
        ".f1c21dwh{background-color:var(--colorTransparentBackground);}"
    ],
    h: [
        ".f146ro5n:hover{background-color:var(--colorSubtleBackgroundLightAlphaHover);}",
        ".fjxutwb:hover{background-color:var(--colorTransparentBackgroundHover);}"
    ],
    a: [
        ".fkam630:active{background-color:var(--colorSubtleBackgroundLightAlphaPressed);}",
        ".fophhak:active{background-color:var(--colorTransparentBackgroundPressed);}"
    ]
});
/**
 * Styles for the action icon slot
 */ const useActionsBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rzvs2in", "r17h8a29", [
    ".rzvs2in{display:flex;margin-left:auto;position:relative;z-index:1;grid-area:aside;padding:0 var(--spacingHorizontalS);}",
    ".r17h8a29{display:flex;margin-right:auto;position:relative;z-index:1;grid-area:aside;padding:0 var(--spacingHorizontalS);}"
]);
/**
 * Styles for the action icon slot
 */ const useAsideBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1825u21", "rezy0yk", [
    ".r1825u21{display:flex;margin-left:auto;align-items:center;z-index:0;grid-area:aside;padding:0 var(--spacingHorizontalM);gap:var(--spacingHorizontalXS);}",
    ".rezy0yk{display:flex;margin-right:auto;align-items:center;z-index:0;grid-area:aside;padding:0 var(--spacingHorizontalM);gap:var(--spacingHorizontalXS);}"
]);
/**
 * Styles for the expand icon slot
 */ const useExpandIconBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rh4pu5o", null, [
    ".rh4pu5o{display:flex;align-items:center;justify-content:center;min-width:24px;box-sizing:border-box;color:var(--colorNeutralForeground3);flex:0 0 auto;padding:var(--spacingVerticalXS) 0;}"
]);
/**
 * Styles for the content slot
 */ const useMainBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rklbe47", null, [
    ".rklbe47{padding:0 var(--spacingHorizontalXXS);}"
]);
/**
 * Styles for the before/after icon slot
 */ const useIconBaseStyles = /*#__PURE__*/ (0, _react.__resetStyles)("rphzgg1", null, [
    ".rphzgg1{display:flex;align-items:center;color:var(--colorNeutralForeground2);line-height:var(--lineHeightBase500);font-size:var(--fontSizeBase500);}"
]);
const useIconBeforeStyles = /*#__PURE__*/ (0, _react.__styles)({
    medium: {
        z189sj: [
            "f7x41pl",
            "fruq291"
        ]
    },
    small: {
        z189sj: [
            "ffczdla",
            "fgiv446"
        ]
    }
}, {
    d: [
        ".f7x41pl{padding-right:var(--spacingHorizontalXS);}",
        ".fruq291{padding-left:var(--spacingHorizontalXS);}",
        ".ffczdla{padding-right:var(--spacingHorizontalXXS);}",
        ".fgiv446{padding-left:var(--spacingHorizontalXXS);}"
    ]
});
const useIconAfterStyles = /*#__PURE__*/ (0, _react.__styles)({
    medium: {
        uwmqm3: [
            "fruq291",
            "f7x41pl"
        ]
    },
    small: {
        uwmqm3: [
            "fgiv446",
            "ffczdla"
        ]
    }
}, {
    d: [
        ".fruq291{padding-left:var(--spacingHorizontalXS);}",
        ".f7x41pl{padding-right:var(--spacingHorizontalXS);}",
        ".fgiv446{padding-left:var(--spacingHorizontalXXS);}",
        ".ffczdla{padding-right:var(--spacingHorizontalXXS);}"
    ]
});
const useTreeItemLayoutStyles_unstable = (state)=>{
    'use no memo';
    const { main, iconAfter, iconBefore, expandIcon, root, aside, actions, selector } = state;
    const rootStyles = useRootStyles();
    const rootBaseStyles = useRootBaseStyles();
    const actionsBaseStyles = useActionsBaseStyles();
    const asideBaseStyles = useAsideBaseStyles();
    const mainBaseStyles = useMainBaseStyles();
    const expandIconBaseStyles = useExpandIconBaseStyles();
    const iconBaseStyles = useIconBaseStyles();
    const iconBeforeStyles = useIconBeforeStyles();
    const iconAfterStyles = useIconAfterStyles();
    const size = (0, _treeContext.useTreeContext_unstable)((ctx)=>ctx.size);
    const appearance = (0, _treeContext.useTreeContext_unstable)((ctx)=>ctx.appearance);
    const itemType = (0, _treeItemContext.useTreeItemContext_unstable)((ctx)=>ctx.itemType);
    root.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.root, rootBaseStyles, rootStyles[appearance], rootStyles[size], rootStyles[itemType], root.className);
    main.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.main, mainBaseStyles, main.className);
    if (expandIcon) {
        expandIcon.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.expandIcon, expandIconBaseStyles, expandIcon.className);
    }
    if (iconBefore) {
        iconBefore.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.iconBefore, iconBaseStyles, iconBeforeStyles[size], iconBefore.className);
    }
    if (iconAfter) {
        iconAfter.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.iconAfter, iconBaseStyles, iconAfterStyles[size], iconAfter.className);
    }
    if (actions) {
        actions.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.actions, actionsBaseStyles, actions.className);
    }
    if (aside) {
        aside.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.aside, asideBaseStyles, aside.className);
    }
    if (selector) {
        selector.className = (0, _react.mergeClasses)(treeItemLayoutClassNames.selector, selector.className);
    }
    return state;
};
