'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "TreeItemChevron", {
    enumerable: true,
    get: function() {
        return TreeItemChevron;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reacticons = require("@fluentui/react-icons");
const _reactmotion = require("@fluentui/react-motion");
const _treeItemContext = require("../contexts/treeItemContext");
const TreeItemChevron = /*#__PURE__*/ _react.memo(()=>{
    const open = (0, _treeItemContext.useTreeItemContext_unstable)((ctx)=>ctx.open);
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    const expandIconRotation = open ? 90 : dir !== 'rtl' ? 0 : 180;
    return /*#__PURE__*/ _react.createElement(_reacticons.ChevronRight12Regular, {
        style: {
            ...expandIconInlineStyles[expandIconRotation],
            transition: `transform ${_reactmotion.durations.durationNormal}ms ${_reactmotion.curves.curveEasyEaseMax}`
        }
    });
});
TreeItemChevron.displayName = 'TreeItemChevron';
const expandIconInlineStyles = {
    90: {
        transform: `rotate(90deg)`
    },
    0: {
        transform: `rotate(0deg)`
    },
    180: {
        transform: `rotate(180deg)`
    }
};
