'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    treeItemClassNames: function() {
        return treeItemClassNames;
    },
    useTreeItemStyles_unstable: function() {
        return useTreeItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const _tokens = require("../../utils/tokens");
const _useTreeItemLayoutStylesstyles = require("../TreeItemLayout/useTreeItemLayoutStyles.styles");
const _useTreeItemPersonaLayoutStylesstyles = require("../TreeItemPersonaLayout/useTreeItemPersonaLayoutStyles.styles");
const treeItemClassNames = {
    root: 'fui-TreeItem'
};
const useBaseStyles = (0, _react.makeResetStyles)({
    position: 'relative',
    cursor: 'pointer',
    display: 'flex',
    flexDirection: 'column',
    boxSizing: 'border-box',
    backgroundColor: _reacttheme.tokens.colorSubtleBackground,
    color: _reacttheme.tokens.colorNeutralForeground2,
    paddingRight: _reacttheme.tokens.spacingHorizontalNone,
    // if using createCustomFocusIndicatorStyle then we need to remove default outline styles provided by the browser
    ':focus': {
        outlineStyle: 'none'
    },
    ':focus-visible': {
        outlineStyle: 'none'
    },
    // This adds the focus outline for the TreeItemLayout element
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        outlineColor: _reacttheme.tokens.colorStrokeFocus2,
        outlineRadius: _reacttheme.tokens.borderRadiusMedium,
        // FIXME: tokens.strokeWidthThick causes some weird bugs
        outlineWidth: '2px',
        outlineStyle: 'solid'
    }, {
        customizeSelector: (selector)=>`${selector} > .${_useTreeItemLayoutStylesstyles.treeItemLayoutClassNames.root}, ${selector} > .${_useTreeItemPersonaLayoutStylesstyles.treeItemPersonaLayoutClassNames.root}`
    })
});
const useStyles = (0, _react.makeStyles)({
    ...Object.fromEntries(Array.from({
        length: 10
    }, (_, index)=>[
            `level${index + 1}`,
            {
                [_tokens.treeItemLevelToken]: index + 1
            }
        ]))
});
const useTreeItemStyles_unstable = (state)=>{
    'use no memo';
    const baseStyles = useBaseStyles();
    const styles = useStyles();
    const { level } = state;
    state.root.className = (0, _react.mergeClasses)(treeItemClassNames.root, baseStyles, isStaticallyDefinedLevel(level) && styles[`level${level}`], state.root.className);
    return state;
};
function isStaticallyDefinedLevel(level) {
    return level >= 1 && level <= 10;
}
