'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTreeContextValues_unstable", {
    enumerable: true,
    get: function() {
        return useTreeContextValues_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
function useTreeContextValues_unstable(state) {
    'use no memo';
    if (state.contextType === 'root') {
        const { openItems, level, contextType, treeType, checkedItems, selectionMode, navigationMode, appearance, size, requestTreeResponse, forceUpdateRovingTabIndex } = state;
        /**
     * This context is created with "@fluentui/react-context-selector",
     * there is no sense to memoize it
     */ const tree = {
            treeType,
            size,
            openItems,
            appearance,
            checkedItems,
            selectionMode,
            navigationMode,
            contextType,
            level,
            requestTreeResponse,
            forceUpdateRovingTabIndex
        };
        return {
            tree
        };
    }
    return {
        // contextType is statically determined by the context
        // eslint-disable-next-line react-hooks/rules-of-hooks
        tree: _react.useMemo(()=>({
                level: state.level,
                contextType: 'subtree'
            }), [
            state.level
        ])
    };
}
