'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useTree_unstable", {
    enumerable: true,
    get: function() {
        return useTree_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _useControllableOpenItems = require("../../hooks/useControllableOpenItems");
const _useNestedControllableCheckedItems = require("./useNestedControllableCheckedItems");
const _subtreeContext = require("../../contexts/subtreeContext");
const _useRootTree = require("../../hooks/useRootTree");
const _useSubtree = require("../../hooks/useSubtree");
const _useTreeNavigation = require("../../hooks/useTreeNavigation");
const _treeContext = require("../../contexts/treeContext");
const _ImmutableSet = require("../../utils/ImmutableSet");
const _ImmutableMap = require("../../utils/ImmutableMap");
const useTree_unstable = (props, ref)=>{
    'use no memo';
    const isRoot = _react.useContext(_subtreeContext.SubtreeContext) === undefined;
    // as level is static, this doesn't break rule of hooks
    // and if this becomes an issue later on, this can be easily converted
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return isRoot ? useNestedRootTree(props, ref) : useNestedSubtree(props, ref);
};
function useNestedRootTree(props, ref) {
    'use no memo';
    const [openItems, setOpenItems] = (0, _useControllableOpenItems.useControllableOpenItems)(props);
    const checkedItems = (0, _useNestedControllableCheckedItems.useNestedCheckedItems)(props);
    const navigation = (0, _useTreeNavigation.useTreeNavigation)(props.navigationMode);
    return Object.assign((0, _useRootTree.useRootTree)({
        ...props,
        openItems,
        checkedItems,
        onOpenChange: (0, _reactutilities.useEventCallback)((event, data)=>{
            var _props_onOpenChange;
            const nextOpenItems = (0, _useControllableOpenItems.createNextOpenItems)(data, openItems);
            (_props_onOpenChange = props.onOpenChange) === null || _props_onOpenChange === void 0 ? void 0 : _props_onOpenChange.call(props, event, {
                ...data,
                openItems: _ImmutableSet.ImmutableSet.dangerouslyGetInternalSet(nextOpenItems)
            });
            setOpenItems(nextOpenItems);
        }),
        onNavigation: (0, _reactutilities.useEventCallback)((event, data)=>{
            var _props_onNavigation;
            (_props_onNavigation = props.onNavigation) === null || _props_onNavigation === void 0 ? void 0 : _props_onNavigation.call(props, event, data);
            if (!event.isDefaultPrevented()) {
                navigation.navigate(data, {
                    preventScroll: data.isScrollPrevented()
                });
            }
        }),
        onCheckedChange: (0, _reactutilities.useEventCallback)((event, data)=>{
            var _props_onCheckedChange;
            const nextCheckedItems = (0, _useNestedControllableCheckedItems.createNextNestedCheckedItems)(data, checkedItems);
            (_props_onCheckedChange = props.onCheckedChange) === null || _props_onCheckedChange === void 0 ? void 0 : _props_onCheckedChange.call(props, event, {
                ...data,
                checkedItems: _ImmutableMap.ImmutableMap.dangerouslyGetInternalMap(nextCheckedItems)
            });
        })
    }, (0, _reactutilities.useMergedRefs)(ref, navigation.treeRef)), {
        treeType: 'nested',
        forceUpdateRovingTabIndex: navigation.forceUpdateRovingTabIndex
    });
}
function useNestedSubtree(props, ref) {
    'use no memo';
    if (process.env.NODE_ENV === 'development') {
        // this doesn't break rule of hooks, as environment is a static value
        // eslint-disable-next-line react-hooks/rules-of-hooks
        const treeType = (0, _treeContext.useTreeContext_unstable)((ctx)=>ctx.treeType);
        if (treeType === 'flat') {
            throw new Error(`@fluentui/react-tree [useTree]:
Subtrees are not allowed in a FlatTree!
You cannot use a <Tree> component inside of a <FlatTree> component!`);
        }
    }
    return (0, _useSubtree.useSubtree)(props, ref);
}
