'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createNextNestedCheckedItems: function() {
        return createNextNestedCheckedItems;
    },
    useNestedCheckedItems: function() {
        return useNestedCheckedItems;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _ImmutableMap = require("../../utils/ImmutableMap");
const _createCheckedItems = require("../../utils/createCheckedItems");
function useNestedCheckedItems(props) {
    return _react.useMemo(()=>(0, _createCheckedItems.createCheckedItems)(props.checkedItems), [
        props.checkedItems
    ]);
}
function createNextNestedCheckedItems(data, previousCheckedItems) {
    if (data.selectionMode === 'single') {
        return _ImmutableMap.ImmutableMap.from([
            [
                data.value,
                data.checked
            ]
        ]);
    }
    if (data.selectionMode === 'multiselect') {
        return previousCheckedItems.set(data.value, data.checked);
    }
    return previousCheckedItems;
}
