'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useHeadlessFlatTree_unstable", {
    enumerable: true,
    get: function() {
        return useHeadlessFlatTree_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _createHeadlessTree = require("../../utils/createHeadlessTree");
const _tokens = require("../../utils/tokens");
const _useFlatTreeNavigation = require("../../hooks/useFlatTreeNavigation");
const _useControllableOpenItems = require("../../hooks/useControllableOpenItems");
const _getTreeItemValueFromElement = require("../../utils/getTreeItemValueFromElement");
const _ImmutableSet = require("../../utils/ImmutableSet");
const _useFlatControllableCheckedItems = require("./useFlatControllableCheckedItems");
const _ImmutableMap = require("../../utils/ImmutableMap");
function useHeadlessFlatTree_unstable(props, options = {}) {
    'use no memo';
    const headlessTree = _react.useMemo(()=>(0, _createHeadlessTree.createHeadlessTree)(props), [
        props
    ]);
    const [openItems, setOpenItems] = (0, _useControllableOpenItems.useControllableOpenItems)(options);
    const [checkedItems, setCheckedItems] = (0, _useFlatControllableCheckedItems.useFlatControllableCheckedItems)(options, headlessTree);
    const navigation = (0, _useFlatTreeNavigation.useFlatTreeNavigation)();
    const treeRef = _react.useRef(null);
    const handleOpenChange = (0, _reactutilities.useEventCallback)((event, data)=>{
        var _options_onOpenChange;
        const nextOpenItems = (0, _useControllableOpenItems.createNextOpenItems)(data, openItems);
        (_options_onOpenChange = options.onOpenChange) === null || _options_onOpenChange === void 0 ? void 0 : _options_onOpenChange.call(options, event, {
            ...data,
            openItems: _ImmutableSet.ImmutableSet.dangerouslyGetInternalSet(nextOpenItems)
        });
        setOpenItems(nextOpenItems);
    });
    const handleCheckedChange = (0, _reactutilities.useEventCallback)((event, data)=>{
        var _options_onCheckedChange;
        const nextCheckedItems = (0, _useFlatControllableCheckedItems.createNextFlatCheckedItems)(data, checkedItems, headlessTree);
        (_options_onCheckedChange = options.onCheckedChange) === null || _options_onCheckedChange === void 0 ? void 0 : _options_onCheckedChange.call(options, event, {
            ...data,
            checkedItems: _ImmutableMap.ImmutableMap.dangerouslyGetInternalMap(nextCheckedItems)
        });
        setCheckedItems(nextCheckedItems);
    });
    const getNextNavigableItem = (0, _reactutilities.useEventCallback)((visibleItems, data)=>{
        const item = headlessTree.get(data.value);
        if (item) {
            switch(data.type){
                case _tokens.treeDataTypes.TypeAhead:
                    return item;
                case _tokens.treeDataTypes.ArrowLeft:
                    return headlessTree.get(item.parentValue);
                case _tokens.treeDataTypes.ArrowRight:
                    return visibleItems[item.index + 1];
                case _tokens.treeDataTypes.End:
                    return visibleItems[visibleItems.length - 1];
                case _tokens.treeDataTypes.Home:
                    return visibleItems[0];
                case _tokens.treeDataTypes.ArrowDown:
                    return visibleItems[item.index + 1];
                case _tokens.treeDataTypes.ArrowUp:
                    return visibleItems[item.index - 1];
            }
        }
    });
    const getElementFromItem = _react.useCallback((item)=>{
        var _treeRef_current;
        return (_treeRef_current = treeRef.current) === null || _treeRef_current === void 0 ? void 0 : _treeRef_current.querySelector(`[${_getTreeItemValueFromElement.dataTreeItemValueAttrName}="${item.value}"]`);
    }, []);
    const ref = (0, _reactutilities.useMergedRefs)(treeRef, navigation.rootRef);
    const getTreeProps = _react.useCallback(()=>{
        var _options_onNavigation;
        return {
            ref,
            openItems,
            selectionMode: options.selectionMode,
            checkedItems,
            onOpenChange: handleOpenChange,
            onCheckedChange: handleCheckedChange,
            onNavigation: (_options_onNavigation = options.onNavigation) !== null && _options_onNavigation !== void 0 ? _options_onNavigation : noop
        };
    }, // eslint-disable-next-line react-hooks/exhaustive-deps
    [
        openItems,
        checkedItems,
        options.selectionMode,
        options.onNavigation
    ]);
    const items = _react.useCallback(()=>headlessTree.visibleItems(openItems), [
        openItems,
        headlessTree
    ]);
    const getItem = _react.useCallback((value)=>headlessTree.get(value), [
        headlessTree
    ]);
    return _react.useMemo(()=>({
            navigate: navigation.navigate,
            getTreeProps,
            getNextNavigableItem,
            getElementFromItem,
            items,
            getItem
        }), [
        navigation.navigate,
        getTreeProps,
        getNextNavigableItem,
        getElementFromItem,
        items,
        getItem
    ]);
}
/** @internal */ function noop() {
/* noop */ }
