'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useFlatTree_unstable", {
    enumerable: true,
    get: function() {
        return useFlatTree_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useRootTree = require("../../hooks/useRootTree");
const _reactutilities = require("@fluentui/react-utilities");
const _useFlatTreeNavigation = require("../../hooks/useFlatTreeNavigation");
const _useSubtree = require("../../hooks/useSubtree");
const _ImmutableSet = require("../../utils/ImmutableSet");
const _ImmutableMap = require("../../utils/ImmutableMap");
const _subtreeContext = require("../../contexts/subtreeContext");
const useFlatTree_unstable = (props, ref)=>{
    'use no memo';
    const isRoot = _react.useContext(_subtreeContext.SubtreeContext) === undefined;
    // as level is static, this doesn't break rule of hooks
    // and if this becomes an issue later on, this can be easily converted
    // eslint-disable-next-line react-hooks/rules-of-hooks
    return isRoot ? useRootFlatTree(props, ref) : useSubFlatTree(props, ref);
};
function useRootFlatTree(props, ref) {
    const navigation = (0, _useFlatTreeNavigation.useFlatTreeNavigation)(props.navigationMode);
    return Object.assign((0, _useRootTree.useRootTree)({
        ...props,
        onNavigation: (0, _reactutilities.useEventCallback)((event, data)=>{
            var _props_onNavigation;
            (_props_onNavigation = props.onNavigation) === null || _props_onNavigation === void 0 ? void 0 : _props_onNavigation.call(props, event, data);
            if (!event.isDefaultPrevented()) {
                navigation.navigate(data);
            }
        })
    }, (0, _reactutilities.useMergedRefs)(ref, navigation.rootRef)), {
        treeType: 'flat',
        forceUpdateRovingTabIndex: navigation.forceUpdateRovingTabIndex
    });
}
function useSubFlatTree(props, ref) {
    if (process.env.NODE_ENV === 'development') {
        throw new Error(`@fluentui/react-tree [useFlatTree]:
Subtrees are not allowed in a FlatTree!
You cannot use a <FlatTree> component inside of another <FlatTree> nor a <Tree> component!`);
    }
    return {
        ...(0, _useSubtree.useSubtree)(props, ref),
        // ------ defaultTreeContextValue
        level: 0,
        contextType: 'root',
        treeType: 'nested',
        selectionMode: 'none',
        openItems: _ImmutableSet.ImmutableSet.empty,
        checkedItems: _ImmutableMap.ImmutableMap.empty,
        requestTreeResponse: noop,
        forceUpdateRovingTabIndex: noop,
        appearance: 'subtle',
        size: 'medium',
        // ------ defaultTreeContextValue
        open: false
    };
}
function noop() {
/* do nothing */ }
