'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    createNextFlatCheckedItems: function() {
        return createNextFlatCheckedItems;
    },
    useFlatControllableCheckedItems: function() {
        return useFlatControllableCheckedItems;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _ImmutableMap = require("../../utils/ImmutableMap");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _createCheckedItems = require("../../utils/createCheckedItems");
function useFlatControllableCheckedItems(props, headlessTree) {
    return (0, _reactutilities.useControllableState)({
        initialState: _ImmutableMap.ImmutableMap.empty,
        state: _react.useMemo(()=>props.selectionMode ? props.checkedItems && (0, _createCheckedItems.createCheckedItems)(props.checkedItems) : undefined, [
            props.checkedItems,
            props.selectionMode
        ]),
        defaultState: props.defaultCheckedItems ? ()=>initializeCheckedItems(props, headlessTree) : undefined
    });
}
function createNextFlatCheckedItems(data, previousCheckedItems, headlessTree) {
    if (data.selectionMode === 'single') {
        return _ImmutableMap.ImmutableMap.from([
            [
                data.value,
                data.checked
            ]
        ]);
    }
    const treeItem = headlessTree.get(data.value);
    if (!treeItem) {
        if (process.env.NODE_ENV !== 'production') {
            // eslint-disable-next-line no-console
            console.error(`@fluentui/react-tree [useHeadlessFlatTree]:
Tree item ${data.value} not found.`);
        }
        return previousCheckedItems;
    }
    let nextCheckedItems = previousCheckedItems;
    for (const children of headlessTree.subtree(data.value)){
        nextCheckedItems = nextCheckedItems.set(children.value, data.checked);
    }
    nextCheckedItems = nextCheckedItems.set(data.value, data.checked);
    let isAncestorsMixed = false;
    for (const parent of headlessTree.ancestors(treeItem.value)){
        // if one parent is mixed, all ancestors are mixed
        if (isAncestorsMixed) {
            nextCheckedItems = nextCheckedItems.set(parent.value, 'mixed');
            continue;
        }
        let checkedChildrenAmount = 0;
        for (const child of headlessTree.children(parent.value)){
            if ((nextCheckedItems.get(child.value) || false) === data.checked) {
                checkedChildrenAmount++;
            }
        }
        // if all children are checked, parent is checked
        if (checkedChildrenAmount === parent.childrenValues.length) {
            nextCheckedItems = nextCheckedItems.set(parent.value, data.checked);
        } else {
            // if one parent is mixed, all ancestors are mixed
            isAncestorsMixed = true;
            nextCheckedItems = nextCheckedItems.set(parent.value, 'mixed');
        }
    }
    return nextCheckedItems;
}
function initializeCheckedItems(props, headlessTree) {
    if (!props.selectionMode) {
        return _ImmutableMap.ImmutableMap.empty;
    }
    let state = (0, _createCheckedItems.createCheckedItems)(props.defaultCheckedItems);
    // if selectionMode is multiselect, we need to calculate the checked state of all children
    // and ancestors of the defaultCheckedItems
    if (props.selectionMode === 'multiselect') {
        for (const [value, checked] of state){
            state = createNextFlatCheckedItems({
                value,
                checked,
                selectionMode: props.selectionMode
            }, state, headlessTree);
        }
    }
    return state;
}
