import type { ArrowDown } from '@fluentui/keyboard-keys';
import type { ArrowLeft } from '@fluentui/keyboard-keys';
import type { ArrowRight } from '@fluentui/keyboard-keys';
import type { ArrowUp } from '@fluentui/keyboard-keys';
import type { AvatarContextValue } from '@fluentui/react-avatar';
import type { AvatarSize } from '@fluentui/react-avatar';
import { ButtonContextValue } from '@fluentui/react-button';
import { Checkbox } from '@fluentui/react-checkbox';
import { CheckboxProps } from '@fluentui/react-checkbox';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import { ContextSelector } from '@fluentui/react-context-selector';
import type { DistributiveOmit } from '@fluentui/react-utilities';
import type { End } from '@fluentui/keyboard-keys';
import type { Enter } from '@fluentui/keyboard-keys';
import type { EventData } from '@fluentui/react-utilities';
import type { EventHandler } from '@fluentui/react-utilities';
import type { ExtractSlotProps } from '@fluentui/react-utilities';
import { ForwardRefComponent } from '@fluentui/react-utilities';
import type { Home } from '@fluentui/keyboard-keys';
import type { JSXElement } from '@fluentui/react-utilities';
import type { PresenceMotionSlotProps } from '@fluentui/react-motion';
import { Radio } from '@fluentui/react-radio';
import { RadioProps } from '@fluentui/react-radio';
import * as React_2 from 'react';
import type { SelectionMode as SelectionMode_2 } from '@fluentui/react-utilities';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

declare type FlattenedTreeItem<Props extends TreeItemProps> = HeadlessFlatTreeItemProps & Props;

/**
 * Converts a nested structure to a flat one which can be consumed by `useFlatTreeItems`
 * @example
 * ```tsx
 * const defaultItems = flattenTree_unstable([
 *  {
 *    children: <TreeItemLayout>level 1, item 1</TreeItemLayout>,
 *    subtree: [
 *      {
 *        children: <TreeItemLayout>level 2, item 1</TreeItemLayout>,
 *      },
 *      {
 *        children: <TreeItemLayout>level 2, item 2</TreeItemLayout>,
 *      },
 *      {
 *        children: <TreeItemLayout>level 2, item 3</TreeItemLayout>,
 *      },
 *    ],
 *  },
 *  {
 *    children: <TreeItemLayout>level 1, item 2</TreeItemLayout>,
 *    subtree: [
 *      {
 *        children: <TreeItemLayout>level 2, item 1</TreeItemLayout>,
 *        subtree: [
 *          {
 *            children: <TreeItemLayout>level 3, item 1</TreeItemLayout>,
 *            subtree: [
 *              {
 *                children: <TreeItemLayout>level 4, item 1</TreeItemLayout>,
 *              },
 *            ],
 *          },
 *        ],
 *      },
 *    ],
 *  },
 * ]);
 * ```
 */
export declare const flattenTree_unstable: <Props extends TreeItemProps>(items: FlattenTreeItem<Props>[]) => FlattenedTreeItem<Props>[];

export declare type FlattenTreeItem<Props extends TreeItemProps> = Omit<Props, 'subtree' | 'itemType'> & {
    value: TreeItemValue;
    subtree?: FlattenTreeItem<Props>[];
};

/**
 * The `FlatTree` component is a variation of the `Tree` component that deals with a flattened data structure.
 *
 * It should be used on cases where more complex interactions with a Tree is required.
 * On simple scenarios it is advised to simply use a nested structure instead.
 */
export declare const FlatTree: ForwardRefComponent<FlatTreeProps>;

export declare const flatTreeClassNames: SlotClassNames<Omit<FlatTreeSlots, 'collapseMotion'>>;

declare type FlatTreeContextValues = {
    tree: TreeContextValue;
};

/**
 * The `FlatTreeItem` component represents a single item in a flat tree.
 */
export declare const FlatTreeItem: ForwardRefComponent<FlatTreeItemProps>;

/**
 * FlatTreeItem Props
 */
export declare type FlatTreeItemProps = TreeItemProps & {
    value: TreeItemValue;
    'aria-level': number;
    'aria-setsize': number;
    'aria-posinset': number;
};

export declare type FlatTreeProps = ComponentProps<TreeSlots> & {
    /**
     * Indicates how navigation between a treeitem and its actions work
     * - 'tree' (default): The default navigation, pressing right arrow key navigates inward the first inner children of a branch treeitem
     * - 'treegrid': Pressing right arrow key navigate towards the actions of a treeitem
     * @default 'tree'
     */
    navigationMode?: 'tree' | 'treegrid';
    /**
     * A tree item can have various appearances:
     * - 'subtle' (default): The default tree item styles.
     * - 'subtle-alpha': Minimizes emphasis on hovered or focused states.
     * - 'transparent': Removes background color.
     * @default 'subtle'
     */
    appearance?: 'subtle' | 'subtle-alpha' | 'transparent';
    /**
     * Size of the tree item.
     * @default 'medium'
     */
    size?: 'small' | 'medium';
    /**
     * This refers to a list of ids of opened tree items.
     * Controls the state of the open tree items.
     * These property is ignored for subtrees.
     */
    openItems?: Iterable<TreeItemValue>;
    /**
     * Callback fired when the component changes value from open state.
     * These property is ignored for subtrees.
     *
     * @param event - a React's Synthetic event
     * @param data - A data object with relevant information,
     * such as open value and type of interaction that created the event.
     */
    onOpenChange?(event: TreeOpenChangeEvent, data: TreeOpenChangeData): void;
    /**
     * Callback fired when navigation happens inside the component.
     * These property is ignored for subtrees.
     *
     * FIXME: This method is not ideal, as navigation should be handled internally by tabster.
     *
     * @param event - a React's Synthetic event
     * @param data - A data object with relevant information,
     */
    onNavigation?(event: TreeNavigationEvent_unstable, data: TreeNavigationData_unstable): void;
    /**
     * This refers to the selection mode of the tree.
     * - undefined: No selection can be done.
     * - 'single': Only one tree item can be selected, radio buttons are rendered.
     * - 'multiselect': Multiple tree items can be selected, checkboxes are rendered.
     *
     * @default undefined
     */
    selectionMode?: SelectionMode_2;
    /**
     * This refers to a list of ids of checked tree items, or a list of tuples of ids and checked state.
     * Controls the state of the checked tree items.
     * These property is ignored for subtrees.
     */
    checkedItems?: Iterable<TreeItemValue | [TreeItemValue, TreeSelectionValue]>;
    /**
     * Callback fired when the component changes value from checked state.
     * These property is ignored for subtrees.
     *
     * @param event - a React's Synthetic event
     * @param data - A data object with relevant information,
     * such as checked value and type of interaction that created the event.
     */
    onCheckedChange?(event: TreeCheckedChangeEvent, data: TreeCheckedChangeData): void;
};

export declare type FlatTreeSlots = TreeSlots;

export declare type FlatTreeState = ComponentState<FlatTreeSlots> & TreeContextValue & {
    open: boolean;
};

/**
 * FlatTree API to manage all required mechanisms to convert a list of items into renderable TreeItems
 * in multiple scenarios including virtualization.
 *
 * !!A flat tree is an unofficial spec for tree!!
 *
 * It should be used on cases where more complex interactions with a Tree is required.
 *
 * On simple scenarios it is advised to simply use a nested structure instead.
 */
export declare type HeadlessFlatTree<Props extends HeadlessFlatTreeItemProps> = {
    /**
     * returns the properties required for the Tree component to work properly.
     * That includes:
     * `openItems`, `onOpenChange`, `onNavigation_unstable` and `ref`
     */
    getTreeProps(): Required<Pick<FlatTreeProps, 'openItems' | 'onOpenChange' | 'onNavigation' | 'checkedItems' | 'onCheckedChange'>> & {
        ref: React_2.Ref<HTMLDivElement>;
        openItems: ImmutableSet<TreeItemValue>;
    };
    /**
     * internal method used to react to an `onNavigation` event.
     * This method ensures proper navigation on keyboard and mouse interaction.
     * In case of virtualization it might be required to cancel default provided `onNavigation`
     * event and then call this method manually.
     *
     * @example
     * ```ts
     * // react-window
     * const handleNavigation = (event, data) => {
     *   event.preventDefault();
     *   const nextItem = tree.getNextNavigableItem(data);
     *   // scroll to item using virtualization scroll mechanism
     *   if (nextItem && tree.getElementFromItem(nextItem)) {
     *     listRef.current.scrollToItem(nextItem.index);
     *   }
     *   // wait for scrolling to happen and then invoke navigate method
     *   requestAnimationFrame(() => {
     *     tree.navigate(data);
     *   });
     * };
     *```
     */
    navigate(data: TreeNavigationData_unstable): void;
    /**
     * returns next item to be focused on a navigation.
     * This method is provided to decouple the element that needs to be focused from
     *  the action of focusing it itself.
     *
     * On the case of TypeAhead navigation this method returns the current item.
     */
    getNextNavigableItem(visibleItems: HeadlessTreeItem<Props>[], data: TreeNavigationData_unstable): HeadlessTreeItem<Props> | undefined;
    /**
     * similar to getElementById but for FlatTreeItems
     */
    getElementFromItem(item: HeadlessTreeItem<Props>): HTMLElement | null;
    /**
     * an iterable containing all visually available flat tree items
     */
    items(): IterableIterator<HeadlessTreeItem<Props>>;
};

export declare type HeadlessFlatTreeItem<Props extends HeadlessFlatTreeItemProps> = HeadlessTreeItem<Props>;

export declare type HeadlessFlatTreeItemProps = HeadlessTreeItemProps;

export declare type HeadlessFlatTreeOptions = Pick<FlatTreeProps, 'onOpenChange' | 'onNavigation' | 'selectionMode' | 'onCheckedChange'> & Pick<TreeProps, 'defaultOpenItems' | 'openItems' | 'checkedItems'> & {
    defaultCheckedItems?: TreeProps['checkedItems'];
};

/**
 * @internal
 */
declare type HeadlessFlatTreeReturn<Props extends HeadlessFlatTreeItemProps> = HeadlessFlatTree<Props> & {
    getItem(value: TreeItemValue): HeadlessTreeItem<Props> | undefined;
};

/**
 * The item that is returned by `createHeadlessTree`, it represents a wrapper around the properties provided to
 * `createHeadlessTree` but with extra information that might be useful on virtual tree scenarios
 */
declare type HeadlessTreeItem<Props extends HeadlessTreeItemProps> = {
    level: number;
    index: number;
    position: number;
    childrenValues: TreeItemValue[];
    value: TreeItemValue;
    parentValue: TreeItemValue | undefined;
    itemType: TreeItemType;
    getTreeItemProps(): Required<Pick<Props, 'value' | 'aria-setsize' | 'aria-level' | 'aria-posinset' | 'itemType'>> & Props;
};

declare type HeadlessTreeItemProps = Omit<TreeItemProps, 'itemType' | 'value'> & {
    value: TreeItemValue;
    itemType?: TreeItemType;
    parentValue?: TreeItemValue;
};

declare class ImmutableMap<Key, Value> implements Iterable<[Key, Value]> {
    static empty: ImmutableMap<never, never>;
    readonly size: number;
    private [internalMapSymbol];
    static dangerouslyGetInternalMap<Key, Value>(immutableMap: ImmutableMap<Key, Value>): Map<Key, Value>;
    static copy<Key, Value>(immutableMap: ImmutableMap<Key, Value>): ImmutableMap<Key, Value>;
    /**
     * Creates a new {@link ImmutableMap} from an iterable.
     * If the iterable is undefined, {@link ImmutableMap.empty} will be returned.
     * If the iterable is already an {@link ImmutableMap}, it will be returned as is no copy will be made.
     */
    static from<T extends [unknown, unknown]>(iterable?: Iterable<T>): ImmutableMap<T[0], T[1]>;
    /**
     * Creates a new {@link ImmutableMap} from an iterable with an auxiliary map function to modify the iterable.
     * If the iterable is undefined, {@link ImmutableMap.empty} will be returned.
     * If the iterable is already an {@link ImmutableMap}, it will be returned as is no copy will be made.
     * The map function will be called for each element in the iterable.
     */
    static from<T, U extends [unknown, unknown]>(iterable: Iterable<T> | undefined, mapFn: (value: T) => U): ImmutableMap<U[0], U[1]>;
    static [Symbol.hasInstance](instance: unknown): boolean;
    /**
     * Do not use this constructor directly, use {@link ImmutableMap.from} instead.
     * {@link ImmutableMap.from} handles instance verification (which might be problematic on {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/instanceof#instanceof_and_multiple_realms | multiple realms}),
     * avoid unnecessary copies, supports iterables and ensures that the internal map is never exposed.
     *
     *⚠️⚠️  _By using this constructor directly, you might end up with a mutable map, as it is not guaranteed that the internal map is not exposed._ ⚠️⚠️
     */
    constructor(internalMap: Map<Key, Value>);
    delete(key: Key): ImmutableMap<Key, Value>;
    get(key: Key): Value | undefined;
    has(key: Key): boolean;
    set(key: Key, value: Value): ImmutableMap<Key, Value>;
    [Symbol.iterator](): Iterator<[Key, Value]>;
}

/**
 * @public
 *
 * Small immutable wrapper around the native Set implementation.
 * Every operation that would modify the set returns a new copy instance.
 */
declare class ImmutableSet<T> implements Iterable<T> {
    static empty: ImmutableSet<never>;
    readonly size: number;
    private [internalSetSymbol];
    static dangerouslyGetInternalSet<Value>(set: ImmutableSet<Value>): Set<Value>;
    static copy<T>(immutableSet: ImmutableSet<T>): ImmutableSet<T>;
    /**
     * Creates a new {@link ImmutableSet} from an iterable.
     * If the iterable is undefined, {@link ImmutableSet.empty} will be returned.
     * If the iterable is already an {@link ImmutableSet}, it will be returned as is no copy will be made.
     */
    static from<Value>(iterable?: Iterable<Value>): ImmutableSet<Value>;
    static [Symbol.hasInstance](instance: unknown): boolean;
    /**
     * Do not use this constructor directly, use {@link ImmutableSet.from} instead.
     * {@link ImmutableSet.from} handles instance verification (which might be problematic on {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/instanceof#instanceof_and_multiple_realms | multiple realms}),
     * avoid unnecessary copies, supports iterables and ensures that the internal set is never exposed.
     *
     *⚠️⚠️  _By using this constructor directly, you might end up with a mutable set, as it is not guaranteed that the internal set is not exposed._ ⚠️⚠️
     */
    constructor(internalSet: Set<T>);
    add(value: T): ImmutableSet<T>;
    delete(value: T): ImmutableSet<T>;
    has(value: T): boolean;
    [Symbol.iterator](): Iterator<T>;
}

declare const internalMapSymbol: unique symbol;

declare const internalSetSymbol: unique symbol;

declare type MultiSelectValue = NonNullable<CheckboxProps['checked']>;

export declare const renderFlatTree_unstable: (state: FlatTreeState, contextValues: FlatTreeContextValues) => JSXElement;

export declare const renderTree_unstable: (state: TreeState, contextValues: TreeContextValues) => JSXElement;

/**
 * Render the final JSX of TreeItem
 */
export declare const renderTreeItem_unstable: (state: TreeItemState, contextValues: TreeItemContextValues) => JSXElement;

/**
 * Render the final JSX of TreeItemLayout
 */
export declare const renderTreeItemLayout_unstable: (state: TreeItemLayoutState) => JSXElement;

/**
 * Render the final JSX of TreeItemPersonaLayout
 */
export declare const renderTreeItemPersonaLayout_unstable: (state: TreeItemPersonaLayoutState, contextValues: TreeItemPersonaLayoutContextValues) => JSXElement;

declare type SingleSelectValue = NonNullable<RadioProps['checked']>;

export declare type SubtreeContextValue = {
    contextType: 'subtree';
    level: number;
};

/**
 * The `Tree` component renders nested items in a hierarchical structure.
 * Use it with `TreeItem` component and layouts components `TreeItemLayout` or `TreeItemPersonaLayout`.
 */
export declare const Tree: ForwardRefComponent<TreeProps>;

export declare type TreeCheckedChangeData = {
    value: TreeItemValue;
    checkedItems: Map<TreeItemValue, TreeSelectionValue>;
    target: HTMLElement;
    event: React_2.ChangeEvent<HTMLElement>;
    type: 'Change';
} & ({
    selectionMode: 'multiselect';
    checked: MultiSelectValue;
} | {
    selectionMode: 'single';
    checked: SingleSelectValue;
});

export declare type TreeCheckedChangeEvent = TreeCheckedChangeData['event'];

export declare const treeClassNames: SlotClassNames<Omit<TreeSlots, 'collapseMotion'>>;

export declare type TreeContextValue = {
    contextType?: 'root';
    level: number;
    treeType: 'nested' | 'flat';
    selectionMode: 'none' | SelectionMode_2;
    appearance: 'subtle' | 'subtle-alpha' | 'transparent';
    size: 'small' | 'medium';
    openItems: ImmutableSet<TreeItemValue>;
    checkedItems: ImmutableMap<TreeItemValue, 'mixed' | boolean>;
    /**
     * requests root Tree component to respond to some tree item event,
     */
    requestTreeResponse(request: TreeItemRequest): void;
    forceUpdateRovingTabIndex?(): void;
    navigationMode?: 'tree' | 'treegrid';
};

export declare type TreeContextValues = {
    tree: TreeContextValue | SubtreeContextValue;
};

/**
 * The `TreeItem` component represents a single item in a tree.
 * It expects a certain order of children to work properly: the first child should be the node itself,
 * and the second child should be a nested subtree in the form of another Tree component or a standalone TreeItem.
 * This order follows the same order as document traversal for the TreeWalker API in JavaScript:
 * https://developer.mozilla.org/en-US/docs/Web/API/TreeWalker.
 * The content and layout of a TreeItem can be defined using the TreeItemLayout or TreeItemPersonaLayout component,
 * which should be used as a direct child of TreeItem.
 *
 * When a TreeItem has nested child subtree, an expand/collapse control is displayed,
 * allowing the user to show or hide the children.
 */
export declare const TreeItem: ForwardRefComponent<TreeItemProps>;

export declare const treeItemClassNames: SlotClassNames<TreeItemSlots>;

export declare type TreeItemContextValue = {
    /**
     * @deprecated - this value is irrelevant for the tree item
     */
    isActionsVisible: boolean;
    /**
     * @deprecated - this value is irrelevant for the tree item
     */
    isAsideVisible: boolean;
    selectionRef: React_2.Ref<HTMLInputElement>;
    actionsRef: React_2.Ref<HTMLDivElement>;
    expandIconRef: React_2.Ref<HTMLDivElement>;
    layoutRef: React_2.Ref<HTMLDivElement>;
    subtreeRef: React_2.Ref<HTMLDivElement>;
    treeItemRef?: React_2.RefObject<HTMLDivElement | null>;
    itemType: TreeItemType;
    value: TreeItemValue;
    open: boolean;
    checked: TreeSelectionValue;
};

declare type TreeItemContextValues = {
    treeItem: TreeItemContextValue;
};

export declare type TreeItemCSSProperties = React_2.CSSProperties & {
    [treeItemLevelToken]?: string | number;
};

/**
 * The `TreeItemLayout` component is used as a child of `TreeItem` to define the content and layout of a tree item.
 * It provides a consistent visual structure for tree items in a `Tree` component.
 * This component should only be used as a direct child of `TreeItem`.
 */
export declare const TreeItemLayout: ForwardRefComponent<TreeItemLayoutProps>;

declare type TreeItemLayoutActionSlotProps = ExtractSlotProps<Slot<'div'> & {
    /**
     * Forces visibility of the aside/action content
     */
    visible?: boolean;
    onVisibilityChange?: EventHandler<TreeItemLayoutActionVisibilityChangeData>;
}>;

declare type TreeItemLayoutActionVisibilityChangeData = (EventData<'mouseover' | 'mouseout', MouseEvent> | EventData<'focus' | 'blur', FocusEvent> | EventData<'blur', React_2.FocusEvent>) & {
    visible: boolean;
};

export declare const treeItemLayoutClassNames: SlotClassNames<TreeItemLayoutSlots>;

/**
 * TreeItemLayout Props
 */
export declare type TreeItemLayoutProps = ComponentProps<Partial<TreeItemLayoutSlots>>;

export declare type TreeItemLayoutSlots = {
    root: Slot<'div'>;
    /**
     * Content. Children of the root slot are automatically rendered here
     */
    main: NonNullable<Slot<'div'>>;
    /**
     * Icon slot that renders right before main content
     */
    iconBefore?: Slot<'div'>;
    /**
     * Icon slot that renders right after main content
     */
    iconAfter?: Slot<'div'>;
    /**
     * Expand icon slot,
     * by default renders a chevron icon to indicate opening and closing
     */
    expandIcon?: Slot<'div'>;
    /**
     * Aside content is normally used to render a badge or other non-actionable content
     */
    aside?: Slot<'div'>;
    /**
     * Actionable elements are normally buttons, menus, or other focusable elements.
     * Those elements are only visibly available if the given tree item is currently active.
     *
     * `actions` and `aside` slots are positioned on the exact same spot,
     * so they won't be visible at the same time.
     * `aside` slot is visible by default meanwhile `actions` slot are only visible when the tree item is active.
     *
     * `actions` slot supports a `visible` prop to force visibility of the actions.
     */
    actions?: Slot<TreeItemLayoutActionSlotProps>;
    selector?: Slot<typeof Checkbox> | Slot<typeof Radio>;
};

/**
 * State used in rendering TreeItemLayout
 */
export declare type TreeItemLayoutState = ComponentState<TreeItemLayoutSlots> & {
    buttonContextValue: ButtonContextValue;
};

export declare const treeItemLevelToken: "--fluent-TreeItem--level";

export declare type TreeItemOpenChangeData = {
    open: boolean;
    value: TreeItemValue;
    target: HTMLElement;
} & ({
    event: React_2.MouseEvent<HTMLElement>;
    type: 'ExpandIconClick';
} | {
    event: React_2.MouseEvent<HTMLElement>;
    type: 'Click';
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof Enter;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof ArrowRight;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof ArrowLeft;
});

export declare type TreeItemOpenChangeEvent = TreeItemOpenChangeData['event'];

/**
 * The `TreeItemPersonaLayout` component is used as a child of `TreeItem` to display a `TreeItem` with a media (typically an avatar) and a description.
 * It provides a more visually appealing representation of a `TreeItem` and is typically used to display a list of people or topics.
 * This component should only be used as a direct child of `TreeItem`.
 */
export declare const TreeItemPersonaLayout: ForwardRefComponent<TreeItemPersonaLayoutProps>;

export declare const treeItemPersonaLayoutClassNames: SlotClassNames<TreeItemPersonaLayoutSlots>;

declare type TreeItemPersonaLayoutContextValues = {
    avatar: AvatarContextValue;
};

/**
 * TreeItemPersonaLayout Props
 */
export declare type TreeItemPersonaLayoutProps = ComponentProps<Partial<TreeItemPersonaLayoutSlots>>;

export declare type TreeItemPersonaLayoutSlots = Pick<TreeItemLayoutSlots, 'actions' | 'aside' | 'expandIcon' | 'selector'> & {
    root: NonNullable<Slot<'div'>>;
    /**
     * Avatar to display.
     */
    media: NonNullable<Slot<'div'>>;
    /**
     * Content. Children of the root slot are automatically rendered here
     */
    main: NonNullable<Slot<'div'>>;
    /**
     * Secondary text that describes or complements the content
     */
    description?: Slot<'div'>;
};

/**
 * State used in rendering TreeItemPersonaLayout
 */
export declare type TreeItemPersonaLayoutState = ComponentState<TreeItemPersonaLayoutSlots> & {
    avatarSize: AvatarSize;
    buttonContextValue: ButtonContextValue;
};

/**
 * TreeItem Props
 */
export declare type TreeItemProps = ComponentProps<Partial<TreeItemSlots>> & {
    /**
     * A tree item can be a leaf or a branch
     */
    itemType: TreeItemType;
    /**
     * A tree item should have a well defined value, in case one is not provided by the user by this prop
     * one will be inferred internally.
     */
    value?: TreeItemValue;
    /**
     * Whether the tree item is in an open state
     *
     * This overrides the open value provided by the root tree,
     * and ensure control of the visibility of the tree item per tree item.
     *
     * NOTE: controlling the open state of a tree item will not affect the open state of its children
     */
    open?: boolean;
    onOpenChange?: (e: TreeItemOpenChangeEvent, data: TreeItemOpenChangeData) => void;
    /**
     * This property is inferred through context on a nested tree, and required for a flat tree.
     */
    parentValue?: TreeItemValue;
};

export declare const TreeItemProvider: React_2.Provider<TreeItemContextValue | undefined> & React_2.FC<React_2.ProviderProps<TreeItemContextValue | undefined>>;

declare type TreeItemRequest = {
    itemType: TreeItemType;
} & ((DistributiveOmit<TreeOpenChangeData, 'openItems'> & {
    requestType: 'open';
}) | (TreeNavigationData_unstable & {
    requestType: 'navigate';
}) | (DistributiveOmit<TreeCheckedChangeData, 'selectionMode' | 'checkedItems'> & {
    requestType: 'selection';
}));

export declare type TreeItemSlots = {
    root: Slot<ExtractSlotProps<Slot<'div'> & {
        style?: TreeItemCSSProperties;
    }>>;
};

/**
 * State used in rendering TreeItem
 */
export declare type TreeItemState = ComponentState<TreeItemSlots> & TreeItemContextValue & {
    level: number;
    itemType: TreeItemType;
};

export declare type TreeItemType = 'leaf' | 'branch';

export declare type TreeItemValue = string | number;

export declare type TreeNavigationData_unstable = {
    target: HTMLElement;
    value: TreeItemValue;
    parentValue: TreeItemValue | undefined;
} & ({
    event: React_2.MouseEvent<HTMLElement>;
    type: 'Click';
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: 'TypeAhead';
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof ArrowRight;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof ArrowLeft;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof ArrowUp;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof ArrowDown;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof Home;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof End;
});

/**
 * To avoid breaking changes on TreeNavigationData
 * we are creating a new type that extends the old one
 * and adds the new methods
 */
export declare type TreeNavigationDataParam = TreeNavigationData_unstable & {
    preventScroll(): void;
    isScrollPrevented(): boolean;
};

export declare type TreeNavigationEvent_unstable = TreeNavigationData_unstable['event'];

export declare type TreeNavigationMode = 'tree' | 'treegrid';

export declare type TreeOpenChangeData = {
    open: boolean;
    openItems: Set<TreeItemValue>;
    value: TreeItemValue;
    target: HTMLElement;
} & ({
    event: React_2.MouseEvent<HTMLElement>;
    type: 'ExpandIconClick';
} | {
    event: React_2.MouseEvent<HTMLElement>;
    type: 'Click';
}
/**
* @deprecated
* Use `type: 'Click'` instead of Enter,
* an enter press will trigger a click event, which will trigger an open change,
* so there is no need to have a separate type for it.
*/
| {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof Enter;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof ArrowRight;
} | {
    event: React_2.KeyboardEvent<HTMLElement>;
    type: typeof ArrowLeft;
});

export declare type TreeOpenChangeEvent = TreeOpenChangeData['event'];

export declare type TreeProps = ComponentProps<TreeSlots> & {
    /**
     * Indicates how navigation between a treeitem and its actions work
     * - 'tree' (default): The default navigation, pressing right arrow key navigates inward the first inner children of a branch treeitem
     * - 'treegrid': Pressing right arrow key navigate towards the actions of a treeitem
     * @default 'tree'
     */
    navigationMode?: TreeNavigationMode;
    /**
     * A tree item can have various appearances:
     * - 'subtle' (default): The default tree item styles.
     * - 'subtle-alpha': Minimizes emphasis on hovered or focused states.
     * - 'transparent': Removes background color.
     * @default 'subtle'
     */
    appearance?: 'subtle' | 'subtle-alpha' | 'transparent';
    /**
     * Size of the tree item.
     * @default 'medium'
     */
    size?: 'small' | 'medium';
    /**
     * This refers to a list of ids of opened tree items.
     * Controls the state of the open tree items.
     * These property is ignored for subtrees.
     */
    openItems?: Iterable<TreeItemValue>;
    /**
     * This refers to a list of ids of default opened items.
     * This property is ignored for subtrees.
     */
    defaultOpenItems?: Iterable<TreeItemValue>;
    /**
     * Callback fired when the component changes value from open state.
     * These property is ignored for subtrees.
     *
     * @param event - a React's Synthetic event
     * @param data - A data object with relevant information,
     * such as open value and type of interaction that created the event.
     */
    onOpenChange?(event: TreeOpenChangeEvent, data: TreeOpenChangeData): void;
    /**
     * Callback fired when navigation happens inside the component.
     * These property is ignored for subtrees.
     *
     * FIXME: This method is not ideal, as navigation should be handled internally by tabster.
     *
     * @param event - a React's Synthetic event
     * @param data - A data object with relevant information,
     */
    onNavigation?(event: TreeNavigationEvent_unstable, data: TreeNavigationDataParam): void;
    /**
     * This refers to the selection mode of the tree.
     * - undefined: No selection can be done.
     * - 'single': Only one tree item can be selected, radio buttons are rendered.
     * - 'multiselect': Multiple tree items can be selected, checkboxes are rendered.
     *
     * @default undefined
     */
    selectionMode?: SelectionMode_2;
    /**
     * This refers to a list of ids of checked tree items, or a list of tuples of ids and checked state.
     * Controls the state of the checked tree items.
     * These property is ignored for subtrees.
     */
    checkedItems?: Iterable<TreeItemValue | [TreeItemValue, TreeSelectionValue]>;
    /**
     * Callback fired when the component changes value from checked state.
     * These property is ignored for subtrees.
     *
     * @param event - a React's Synthetic event
     * @param data - A data object with relevant information,
     * such as checked value and type of interaction that created the event.
     */
    onCheckedChange?(event: TreeCheckedChangeEvent, data: TreeCheckedChangeData): void;
};

export declare const TreeProvider: {
    (props: React_2.ProviderProps<TreeContextValue | SubtreeContextValue>): JSXElement;
    displayName: string;
};

export declare const TreeRootReset: (props: TreeRootResetProps) => JSXElement;

declare type TreeRootResetProps = {
    children?: React_2.ReactNode;
};

export declare type TreeSelectionValue = MultiSelectValue | SingleSelectValue;

export declare type TreeSlots = {
    root: Slot<'div'>;
    collapseMotion?: Slot<PresenceMotionSlotProps>;
};

/**
 * State used in rendering Tree
 */
export declare type TreeState = ComponentState<TreeSlots> & {
    open: boolean;
} & (TreeContextValue | SubtreeContextValue);

export declare const useFlatTree_unstable: (props: FlatTreeProps, ref: React_2.Ref<HTMLElement>) => FlatTreeState;

export declare const useFlatTreeContextValues_unstable: (state: FlatTreeState) => FlatTreeContextValues;

export declare const useFlatTreeStyles_unstable: (state: FlatTreeState) => FlatTreeState;

/**
 * this hook provides FlatTree API to manage all required mechanisms to convert a list of items into renderable TreeItems
 * in multiple scenarios including virtualization.
 *
 * !!A flat tree is an unofficial spec for tree!!
 *
 * It should be used on cases where more complex interactions with a Tree is required.
 * On simple scenarios it is advised to simply use a nested structure instead.
 *
 * @param props - a list of tree items
 * @param options - in case control over the internal openItems is required
 */
export declare function useHeadlessFlatTree_unstable<Props extends HeadlessTreeItemProps>(props: Props[], options?: HeadlessFlatTreeOptions): HeadlessFlatTreeReturn<Props>;

export declare const useSubtreeContext_unstable: () => SubtreeContextValue;

export declare const useTree_unstable: (props: TreeProps, ref: React_2.Ref<HTMLElement>) => TreeState;

export declare const useTreeContext_unstable: <T>(selector: ContextSelector<TreeContextValue, T>) => T;

export declare function useTreeContextValues_unstable(state: TreeState): TreeContextValues;

/**
 * Create the state required to render TreeItem.
 *
 * The returned state can be modified with hooks such as useTreeItemStyles_unstable,
 * before being passed to renderTreeItem_unstable.
 *
 * @param props - props from this instance of TreeItem
 * @param ref - reference to root HTMLElement of TreeItem
 */
export declare function useTreeItem_unstable(props: TreeItemProps, ref: React_2.Ref<HTMLDivElement>): TreeItemState;

export declare const useTreeItemContext_unstable: <T>(selector: ContextSelector<TreeItemContextValue, T>) => T;

export declare function useTreeItemContextValues_unstable(state: TreeItemState): TreeItemContextValues;

/**
 * Create the state required to render TreeItemLayout.
 *
 * The returned state can be modified with hooks such as useTreeItemLayoutStyles_unstable,
 * before being passed to renderTreeItemLayout_unstable.
 *
 * @param props - props from this instance of TreeItemLayout
 * @param ref - reference to root HTMLElement of TreeItemLayout
 */
export declare const useTreeItemLayout_unstable: (props: TreeItemLayoutProps, ref: React_2.Ref<HTMLElement>) => TreeItemLayoutState;

/**
 * Apply styling to the TreeItemLayout slots based on the state
 */
export declare const useTreeItemLayoutStyles_unstable: (state: TreeItemLayoutState) => TreeItemLayoutState;

/**
 * Create the state required to render TreeItemPersonaLayout.
 *
 * The returned state can be modified with hooks such as useTreeItemPersonaLayoutStyles_unstable,
 * before being passed to renderTreeItemPersonaLayout_unstable.
 *
 * @param props - props from this instance of TreeItemPersonaLayout
 * @param ref - reference to root HTMLElement of TreeItemPersonaLayout
 */
export declare const useTreeItemPersonaLayout_unstable: (props: TreeItemPersonaLayoutProps, ref: React_2.Ref<HTMLSpanElement>) => TreeItemPersonaLayoutState;

/**
 * Apply styling to the TreeItemPersonaLayout slots based on the state
 */
export declare const useTreeItemPersonaLayoutStyles_unstable: (state: TreeItemPersonaLayoutState) => TreeItemPersonaLayoutState;

/**
 * Apply styling to the TreeItem slots based on the state
 */
export declare const useTreeItemStyles_unstable: (state: TreeItemState) => TreeItemState;

/***
 * Hook used to manage navigation in the tree.
 *
 * @param navigationMode - the navigation mode of the tree, 'tree' (default) or 'treegrid'
 */
export declare function useTreeNavigation(navigationMode?: TreeNavigationMode): {
    navigate: (data: TreeNavigationData_unstable, focusOptions?: FocusOptions) => HTMLElement | null;
    treeRef: React_2.RefCallback<HTMLElement>;
    forceUpdateRovingTabIndex: () => void;
};

export declare const useTreeStyles_unstable: (state: TreeState) => TreeState;

export { }
