'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { createArrowStyles } from '@fluentui/react-positioning';
import { tokens } from '@fluentui/react-theme';
import { arrowHeight } from './private/constants';
export const tooltipClassNames = {
  content: 'fui-Tooltip__content'
};
/**
 * Styles for the tooltip
 */
const useStyles = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "fjseox",
    B7ck84d: "f1ewtqcl",
    B2u0y6b: "f132xexn",
    Bceei9c: "f158kwzp",
    Bahqtrf: "fk6fouc",
    Be2twd7: "fy9rknc",
    Bg96gwp: "fwrc4pm",
    Btd35i7: "fokg9q4",
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f9ggezi",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1bzqsji",
    De3pzq: "fxugw4r",
    sj55zd: "f19n0e5",
    Bhu2qc9: "fxeb0a7"
  },
  visible: {
    mc9l5x: "ftgm304"
  },
  inverted: {
    De3pzq: "fg3r6xk",
    sj55zd: "fonrgv7"
  },
  arrow: {
    B7ck84d: "f1ewtqcl",
    qhf8xq: "f1euv43f",
    Bj3rh1h: "f1bsuimh",
    rhnwrx: "f1s3jn22",
    Bdy53xb: "fv40uqz",
    De3pzq: "f1u2r49w",
    B2eet1l: "fqhgnl",
    Beyfa6y: "f17bz04i",
    Bz10aip: "f36o3x3",
    Bqenvij: "fzofk8q",
    a9b677: "f1wbx1ie",
    Ftih45: "f1wl9k8s",
    Br0sdwz: "f1aocrix",
    cmx5o7: "f1ljr5q2",
    susq4k: 0,
    Biibvgv: 0,
    Bicfajf: 0,
    qehafq: 0,
    Brs5u8j: "f155f1qt",
    Ccq8qp: "f9mhzq7",
    Baz25je: "fr6rhvx",
    Bcgcnre: 0,
    Bqjgrrk: 0,
    qa3bma: 0,
    y0oebl: 0,
    Biqmznv: 0,
    Bm6vgfq: 0,
    Bbv0w2i: 0,
    uvfttm: 0,
    eqrjj: 0,
    Bk5zm6e: 0,
    m598lv: 0,
    B4f6apu: 0,
    ydt019: 0,
    Bq4z7u6: 0,
    Bdkvgpv: 0,
    B0qfbqy: 0,
    kj8mxx: "f1kc0wz4",
    r59vdv: "fgq90dz",
    Bkw5xw4: "fq0y47f",
    hl6cv3: "f1pwrbz6",
    aea9ga: "f1hxxcvm",
    yayu3t: "fw8rgyo",
    Bhsv975: "f1wnzycx",
    rhl9o9: "f1730wal",
    B7gxrvb: "f1fy4ixr",
    B6q6orb: "fobkauc",
    B0lu1f8: "f16bqv1l"
  }
}, {
  d: [".fjseox{display:none;}", ".f1ewtqcl{box-sizing:border-box;}", ".f132xexn{max-width:240px;}", ".f158kwzp{cursor:default;}", ".fk6fouc{font-family:var(--fontFamilyBase);}", ".fy9rknc{font-size:var(--fontSizeBase200);}", ".fwrc4pm{line-height:var(--lineHeightBase200);}", ".fokg9q4{overflow-wrap:break-word;}", [".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f9ggezi{border:1px solid var(--colorTransparentStroke);}", {
    p: -2
  }], [".f1bzqsji{padding:4px 11px 6px 11px;}", {
    p: -1
  }], ".fxugw4r{background-color:var(--colorNeutralBackground1);}", ".f19n0e5{color:var(--colorNeutralForeground1);}", ".fxeb0a7{filter:drop-shadow(0 0 2px var(--colorNeutralShadowAmbient)) drop-shadow(0 4px 8px var(--colorNeutralShadowKey));}", ".ftgm304{display:block;}", ".fg3r6xk{background-color:var(--colorNeutralBackgroundStatic);}", ".fonrgv7{color:var(--colorNeutralForegroundStaticInverted);}", ".f1euv43f{position:absolute;}", ".f1bsuimh{z-index:-1;}", ".f1s3jn22{--fui-positioning-arrow-height:8.484px;}", ".fv40uqz{--fui-positioning-arrow-offset:-4.242px;}", ".f1u2r49w{background-color:inherit;}", ".fqhgnl{background-clip:content-box;}", ".f17bz04i{border-bottom-left-radius:var(--borderRadiusSmall);}", ".f36o3x3{transform:rotate(var(--fui-positioning-arrow-angle));}", ".fzofk8q{height:var(--fui-positioning-arrow-height);}", ".f1wbx1ie{width:var(--fui-positioning-arrow-height);}", ".f1wl9k8s::before{content:\"\";}", ".f1aocrix::before{display:block;}", ".f1ljr5q2::before{background-color:inherit;}", [".f155f1qt::before{margin:-1px;}", {
    p: -1
  }], ".f9mhzq7::before{width:100%;}", ".fr6rhvx::before{height:100%;}", [".f1kc0wz4::before{border:1px solid var(--colorTransparentStroke);}", {
    p: -2
  }], ".fgq90dz::before{border-bottom-left-radius:var(--borderRadiusSmall);}", ".fq0y47f::before{clip-path:polygon(0% 0%, 100% 100%, 0% 100%);}", "[data-popper-placement^=\"top\"] .f1pwrbz6{bottom:var(--fui-positioning-arrow-offset);}", "[data-popper-placement^=\"top\"] .f1hxxcvm{--fui-positioning-arrow-angle:-45deg;}", "[data-popper-placement^=\"right\"] .fw8rgyo{left:var(--fui-positioning-arrow-offset);}", "[data-popper-placement^=\"right\"] .f1wnzycx{--fui-positioning-arrow-angle:45deg;}", "[data-popper-placement^=\"bottom\"] .f1730wal{top:var(--fui-positioning-arrow-offset);}", "[data-popper-placement^=\"bottom\"] .f1fy4ixr{--fui-positioning-arrow-angle:135deg;}", "[data-popper-placement^=\"left\"] .fobkauc{right:var(--fui-positioning-arrow-offset);}", "[data-popper-placement^=\"left\"] .f16bqv1l{--fui-positioning-arrow-angle:225deg;}"]
});
/**
 * Apply styling to the Tooltip slots based on the state
 */
export const useTooltipStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  state.content.className = mergeClasses(tooltipClassNames.content, styles.root, state.appearance === 'inverted' && styles.inverted, state.visible && styles.visible, state.content.className);
  state.arrowClassName = styles.arrow;
  return state;
};