'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    tooltipClassNames: function() {
        return tooltipClassNames;
    },
    useTooltipStyles_unstable: function() {
        return useTooltipStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reactpositioning = require("@fluentui/react-positioning");
const _reacttheme = require("@fluentui/react-theme");
const _constants = require("./private/constants");
const tooltipClassNames = {
    content: 'fui-Tooltip__content'
};
/**
 * Styles for the tooltip
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'none',
        boxSizing: 'border-box',
        maxWidth: '240px',
        cursor: 'default',
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        fontSize: _reacttheme.tokens.fontSizeBase200,
        lineHeight: _reacttheme.tokens.lineHeightBase200,
        overflowWrap: 'break-word',
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        border: `1px solid ${_reacttheme.tokens.colorTransparentStroke}`,
        padding: '4px 11px 6px 11px',
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        color: _reacttheme.tokens.colorNeutralForeground1,
        // TODO need to add versions of tokens.alias.shadow.shadow8, etc. that work with filter
        filter: `drop-shadow(0 0 2px ${_reacttheme.tokens.colorNeutralShadowAmbient}) ` + `drop-shadow(0 4px 8px ${_reacttheme.tokens.colorNeutralShadowKey})`
    },
    visible: {
        display: 'block'
    },
    inverted: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundStatic,
        color: _reacttheme.tokens.colorNeutralForegroundStaticInverted
    },
    arrow: (0, _reactpositioning.createArrowStyles)({
        arrowHeight: _constants.arrowHeight
    })
});
const useTooltipStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.content.className = (0, _react.mergeClasses)(tooltipClassNames.content, styles.root, state.appearance === 'inverted' && styles.inverted, state.visible && styles.visible, state.content.className);
    state.arrowClassName = styles.arrow;
    return state;
};
