'use client';
import * as React from 'react';
import { renderToolbarGroup_unstable, useToolbarGroupStyles_unstable, useToolbarGroup_unstable } from '../../ToolbarGroup';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * ToolbarRadioGroup component is a Button to be used inside Toolbar
 * which will respect toolbar props such as `size`
 */ export const ToolbarRadioGroup = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useToolbarGroup_unstable({
        role: 'radiogroup',
        ...props
    }, ref);
    useToolbarGroupStyles_unstable(state);
    useCustomStyleHook_unstable('useToolbarGroupStyles_unstable')(state);
    return renderToolbarGroup_unstable(state);
// Casting is required due to lack of distributive union to support unions on @types/react
});
ToolbarRadioGroup.displayName = 'ToolbarRadioGroup';
