'use client';

import { tokens } from '@fluentui/react-theme';
import { __styles, mergeClasses } from '@griffel/react';
import { useToggleButtonStyles_unstable } from '@fluentui/react-button';
const useBaseStyles = /*#__PURE__*/__styles({
  selected: {
    De3pzq: "fq5gl1p",
    sj55zd: "f1eryozh"
  },
  iconSelected: {
    sj55zd: "f1qj7y59"
  }
}, {
  d: [".fq5gl1p{background-color:var(--colorSubtleBackgroundSelected);}", ".f1eryozh{color:var(--colorNeutralForeground2Selected);}", ".f1qj7y59{color:var(--colorNeutralForeground2BrandSelected);}"]
});
/**
 * Apply styling to the ToolbarRadioButton slots based on the state
 */
export const useToolbarRadioButtonStyles_unstable = state => {
  'use no memo';

  const toggleButtonStyles = useBaseStyles();
  state.root.className = mergeClasses(state.checked && toggleButtonStyles.selected, state.root.className);
  if (state.icon) {
    state.icon.className = mergeClasses(state.checked && toggleButtonStyles.iconSelected, state.icon.className);
  }
  useToggleButtonStyles_unstable(state);
  return state;
};