'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useToolbarRadioButton_unstable", {
    enumerable: true,
    get: function() {
        return useToolbarRadioButton_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactbutton = require("@fluentui/react-button");
const _ToolbarContext = require("../Toolbar/ToolbarContext");
const useToolbarRadioButton_unstable = (props, ref)=>{
    const handleRadio = (0, _ToolbarContext.useToolbarContext_unstable)((ctx)=>ctx.handleRadio);
    const checked = (0, _ToolbarContext.useToolbarContext_unstable)((ctx)=>{
        var _ctx_checkedValues_props_name;
        return !!((_ctx_checkedValues_props_name = ctx.checkedValues[props.name]) === null || _ctx_checkedValues_props_name === void 0 ? void 0 : _ctx_checkedValues_props_name.includes(props.value));
    });
    const size = (0, _ToolbarContext.useToolbarContext_unstable)((ctx)=>ctx.size);
    const { onClick: onClickOriginal } = props;
    const toggleButtonState = (0, _reactbutton.useToggleButton_unstable)({
        size,
        checked,
        role: 'radio',
        'aria-checked': checked,
        ...props
    }, ref);
    const state = {
        ...toggleButtonState,
        name: props.name,
        value: props.value
    };
    const handleOnClick = (0, _reactutilities.useEventCallback)((e)=>{
        handleRadio === null || handleRadio === void 0 ? void 0 : handleRadio(e, state.name, state.value, state.checked);
        onClickOriginal === null || onClickOriginal === void 0 ? void 0 : onClickOriginal(e);
    });
    state.root['aria-pressed'] = undefined;
    state.root.onClick = handleOnClick;
    return state;
};
