'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    toolbarClassNames: function() {
        return toolbarClassNames;
    },
    useToolbarStyles_unstable: function() {
        return useToolbarStyles_unstable;
    }
});
const _react = require("@griffel/react");
const toolbarClassNames = {
    root: 'fui-Toolbar'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        alignItems: 'center',
        padding: '4px 8px'
    },
    vertical: {
        flexDirection: 'column',
        width: 'fit-content'
    },
    small: {
        padding: '0px 4px'
    },
    medium: {
        padding: '4px 8px'
    },
    large: {
        padding: '4px 20px'
    }
});
const useToolbarStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { vertical, size } = state;
    state.root.className = (0, _react.mergeClasses)(toolbarClassNames.root, styles.root, vertical && styles.vertical, size === 'small' && !vertical && styles.small, size === 'medium' && !vertical && styles.medium, size === 'large' && !vertical && styles.large, state.root.className);
    return state;
};
