'use client';
import * as React from 'react';
import { getIntrinsicElementProps, useEventCallback, useMergedRefs, slot } from '@fluentui/react-utilities';
import { useFluent_unstable as useFluent } from '@fluentui/react-shared-contexts';
import { useFocusableGroup } from '@fluentui/react-tabster';
import { Escape } from '@fluentui/keyboard-keys';
import { TOAST_POSITIONS, useToaster } from '../../state';
import { ToastContainer } from '../ToastContainer';
import { useToasterFocusManagement_unstable } from './useToasterFocusManagement';
import { useToastAnnounce } from './useToastAnnounce';
/**
 * Create the state required to render Toaster.
 *
 * @param props - props from this instance of Toaster
 */ export const useToaster_unstable = (props)=>{
    'use no memo';
    const { offset, announce: announceProp, mountNode, inline = false, ...rest } = props;
    const announceRef = React.useRef(()=>null);
    const { toastsToRender, isToastVisible, pauseAllToasts, playAllToasts, tryRestoreFocus, closeAllToasts } = useToaster(rest);
    const announce = React.useCallback((message, options)=>announceRef.current(message, options), []);
    const { dir } = useFluent();
    const { onKeyDown: onKeyDownProp, ...rootProps } = slot.always(getIntrinsicElementProps('div', rest), {
        elementType: 'div'
    });
    const focusableGroupAttr = useFocusableGroup({
        tabBehavior: 'limited-trap-focus',
        ignoreDefaultKeydown: {
            Escape: true
        }
    });
    const onKeyDown = useEventCallback((e)=>{
        if (e.key === Escape) {
            e.preventDefault();
            closeAllToasts();
        }
        onKeyDownProp === null || onKeyDownProp === void 0 ? void 0 : onKeyDownProp(e);
    });
    const usePositionSlot = (toastPosition)=>{
        var _toastsToRender_get;
        const focusManagementRef = useToasterFocusManagement_unstable(pauseAllToasts, playAllToasts);
        const { announceToast, toasterRef } = useToastAnnounce(announceProp !== null && announceProp !== void 0 ? announceProp : announce);
        return slot.optional(toastsToRender.has(toastPosition) ? rootProps : null, {
            defaultProps: {
                ref: useMergedRefs(focusManagementRef, toasterRef),
                children: (_toastsToRender_get = toastsToRender.get(toastPosition)) === null || _toastsToRender_get === void 0 ? void 0 : _toastsToRender_get.map((toast)=>/*#__PURE__*/ React.createElement(ToastContainer, {
                        ...toast,
                        tryRestoreFocus: tryRestoreFocus,
                        intent: toast.intent,
                        announce: announceToast,
                        key: toast.toastId,
                        visible: isToastVisible(toast.toastId)
                    }, toast.content)),
                onKeyDown,
                ...focusableGroupAttr,
                'data-toaster-position': toastPosition,
                role: 'list'
            },
            elementType: 'div'
        });
    };
    return {
        dir,
        mountNode,
        components: {
            root: 'div',
            bottomStart: 'div',
            bottomEnd: 'div',
            topStart: 'div',
            topEnd: 'div',
            top: 'div',
            bottom: 'div'
        },
        root: slot.always(rootProps, {
            elementType: 'div'
        }),
        bottomStart: usePositionSlot(TOAST_POSITIONS.bottomStart),
        bottomEnd: usePositionSlot(TOAST_POSITIONS.bottomEnd),
        topStart: usePositionSlot(TOAST_POSITIONS.topStart),
        topEnd: usePositionSlot(TOAST_POSITIONS.topEnd),
        top: usePositionSlot(TOAST_POSITIONS.top),
        bottom: usePositionSlot(TOAST_POSITIONS.bottom),
        announceRef,
        offset,
        announce: announceProp !== null && announceProp !== void 0 ? announceProp : announce,
        renderAriaLive: !announceProp,
        inline
    };
};
