'use client';
import * as React from 'react';
import { applyTriggerPropsToChildren, getTriggerChild, getReactElementRef, useEventCallback } from '@fluentui/react-utilities';
import { useARIAButtonProps } from '@fluentui/react-aria';
import { useToastContainerContext } from '../../contexts/toastContainerContext';
/**
 * A non-visual component that wraps its child
 * and configures them to be the trigger that will close a `Toast`.
 * This component should only accept one child.
 *
 * This component sole purpose is to avoid opting out of the internal controlled open state of a `Toast`
 * Besides being a trigger that closes a toast through context this component doesn't do much,
 * making it basically unnecessary in cases where the trigger is outside of a toast.
 */ export const useToastTrigger_unstable = (props)=>{
    const { children, disableButtonEnhancement = false } = props;
    const { close } = useToastContainerContext();
    const child = getTriggerChild(children);
    const handleClick = useEventCallback((e)=>{
        var _child_props_onClick, _child_props;
        child === null || child === void 0 ? void 0 : (_child_props_onClick = (_child_props = child.props).onClick) === null || _child_props_onClick === void 0 ? void 0 : _child_props_onClick.call(_child_props, e);
        if (!e.isDefaultPrevented()) {
            close();
        }
    });
    const triggerChildProps = {
        ...child === null || child === void 0 ? void 0 : child.props,
        ref: getReactElementRef(child),
        onClick: handleClick
    };
    const ariaButtonTriggerChildProps = useARIAButtonProps((child === null || child === void 0 ? void 0 : child.type) === 'button' || (child === null || child === void 0 ? void 0 : child.type) === 'a' ? child.type : 'div', {
        ...triggerChildProps,
        type: 'button'
    });
    return {
        children: applyTriggerPropsToChildren(children, disableButtonEnhancement ? triggerChildProps : ariaButtonTriggerChildProps)
    };
};
