'use client';

import { __resetStyles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { createCustomFocusIndicatorStyle } from '@fluentui/react-tabster';
export const toastContainerClassNames = {
  root: 'fui-ToastContainer',
  timer: 'fui-ToastContainer__timer'
};
const useRootBaseClassName = /*#__PURE__*/__resetStyles("r98b696", null, [".r98b696{box-sizing:border-box;margin-top:16px;pointer-events:all;border-radius:var(--borderRadiusMedium);}", ".r98b696[data-fui-focus-visible]{outline:var(--strokeWidthThick) solid var(--colorStrokeFocus2);}"]);
/**
 * Apply styling to the ToastContainer slots based on the state
 */
export const useToastContainerStyles_unstable = state => {
  'use no memo';

  const rootBaseClassName = useRootBaseClassName();
  state.root.className = mergeClasses(toastContainerClassNames.root, rootBaseClassName, state.root.className);
  return state;
};