'use client';
import * as React from 'react';
import { useToastContainer_unstable } from './useToastContainer';
import { renderToastContainer_unstable } from './renderToastContainer';
import { useToastContainerStyles_unstable } from './useToastContainerStyles.styles';
import { useToastContainerContextValues_unstable } from './useToastContainerContextValues';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * ToastContainer component
 */ export const ToastContainer = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useToastContainer_unstable(props, ref);
    useToastContainerStyles_unstable(state);
    useCustomStyleHook_unstable('useToastContainerStyles_unstable')(state);
    return renderToastContainer_unstable(state, useToastContainerContextValues_unstable(state));
});
ToastContainer.displayName = 'ToastContainer';
