'use client';

import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
export const toastBodyClassNames = {
  root: 'fui-ToastBody',
  subtitle: 'fui-ToastBody__subtitle'
};
const useRootBaseClassName = /*#__PURE__*/__resetStyles("r1u44l4o", null, [".r1u44l4o{grid-column-start:2;grid-column-end:3;padding-top:6px;font-size:var(--fontSizeBase300);line-height:var(--lineHeightBase300);font-weight:var(--fontWeightRegular);color:var(--colorNeutralForeground1);word-break:break-word;}"]);
const useSubtitleBaseClassName = /*#__PURE__*/__resetStyles("rzjw1xk", null, [".rzjw1xk{padding-top:4px;grid-column-start:2;grid-column-end:3;font-size:var(--fontSizeBase200);line-height:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);color:var(--colorNeutralForeground2);}"]);
const useInvertedStyles = /*#__PURE__*/__styles({
  root: {
    sj55zd: "f1w7i9ko"
  },
  subtitle: {
    sj55zd: "f1w7i9ko"
  }
}, {
  d: [".f1w7i9ko{color:var(--colorNeutralForegroundInverted2);}"]
});
/**
 * Apply styling to the ToastBody slots based on the state
 */
export const useToastBodyStyles_unstable = state => {
  'use no memo';

  const rootBaseClassName = useRootBaseClassName();
  const subtitleBaseClassName = useSubtitleBaseClassName();
  const invertedStyles = useInvertedStyles();
  state.root.className = mergeClasses(toastBodyClassNames.root, rootBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.root, state.root.className);
  if (state.subtitle) {
    state.subtitle.className = mergeClasses(toastBodyClassNames.subtitle, subtitleBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.subtitle, state.subtitle.className);
  }
  return state;
};