'use client';
import * as React from 'react';
import { useToast_unstable } from './useToast';
import { renderToast_unstable } from './renderToast';
import { useToastStyles_unstable } from './useToastStyles.styles';
import { useToastContextValues_unstable } from './useToastContextValues';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * Toast component
 */ export const Toast = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useToast_unstable(props, ref);
    useToastStyles_unstable(state);
    useCustomStyleHook_unstable('useToastStyles_unstable')(state);
    return renderToast_unstable(state, useToastContextValues_unstable(state));
});
Toast.displayName = 'Toast';
