'use client';
import * as React from 'react';
import { useBaseAnimationStyles } from './useTimerStyles.styles';
export const Timer = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const baseAnimationStyles = useBaseAnimationStyles();
    const { running, timeout, onTimeout } = props;
    const style = {
        animationDuration: `${timeout}ms`,
        animationPlayState: running ? 'running' : 'paused'
    };
    if (timeout < 0) {
        return null;
    }
    return /*#__PURE__*/ React.createElement("span", {
        onAnimationEnd: onTimeout,
        "data-timer-status": style.animationPlayState,
        ref: ref,
        style: style,
        className: baseAnimationStyles
    });
});
Timer.displayName = 'Timer';
