'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useToastController", {
    enumerable: true,
    get: function() {
        return useToastController;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _vanilla = require("./vanilla");
const noop = ()=>undefined;
function useToastController(toasterId) {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    return _react.useMemo(()=>{
        if (!targetDocument) {
            return {
                dispatchToast: noop,
                dismissToast: noop,
                dismissAllToasts: noop,
                updateToast: noop,
                pauseToast: noop,
                playToast: noop
            };
        }
        return {
            dispatchToast: (content, options)=>{
                (0, _vanilla.dispatchToast)(content, {
                    ...options,
                    toasterId,
                    data: {
                        root: options === null || options === void 0 ? void 0 : options.root
                    }
                }, targetDocument);
            },
            dismissToast: (toastId)=>{
                (0, _vanilla.dismissToast)(toastId, toasterId, targetDocument);
            },
            dismissAllToasts: ()=>{
                (0, _vanilla.dismissAllToasts)(toasterId, targetDocument);
            },
            updateToast: (options)=>{
                (0, _vanilla.updateToast)({
                    ...options,
                    data: {
                        root: options.root
                    },
                    toasterId
                }, targetDocument);
            },
            pauseToast: (toastId)=>{
                (0, _vanilla.pauseToast)(toastId, toasterId, targetDocument);
            },
            playToast: (toastId)=>{
                (0, _vanilla.playToast)(toastId, toasterId, targetDocument);
            }
        };
    }, [
        targetDocument,
        toasterId
    ]);
}
