'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useToasterFocusManagement_unstable", {
    enumerable: true,
    get: function() {
        return useToasterFocusManagement_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _ToastContainer = require("../ToastContainer");
const noop = ()=>undefined;
function useToasterFocusManagement_unstable(pauseAllToasts, playAllToasts) {
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const cleanupListenersRef = _react.useRef(noop);
    return _react.useCallback((el)=>{
        if (!el || !targetDocument) {
            cleanupListenersRef.current();
            cleanupListenersRef.current = noop;
            return;
        }
        const toastContainerWalker = targetDocument.createTreeWalker(el, NodeFilter.SHOW_ELEMENT, {
            acceptNode (node) {
                if ((0, _reactutilities.isHTMLElement)(node) && node.classList.contains(_ToastContainer.toastContainerClassNames.root)) {
                    return NodeFilter.FILTER_ACCEPT;
                }
                return NodeFilter.FILTER_SKIP;
            }
        });
        /**
       * FIXME: https://github.com/microsoft/tabster/issues/299
       * Toasts  should be arrow navigable and focus should be trapped in a stack of tasts
       * This is a temporary measure, Tabster does not have an API yet to enable mover arrow keys from within grouppers
       * Once tabster fully supports this use case, remove this hook
       */ const keydownListener = (e)=>{
            const { target, key } = e;
            if (!(0, _reactutilities.isHTMLElement)(target)) {
                return;
            }
            if (key === _keyboardkeys.ArrowDown) {
                toastContainerWalker.currentNode = target;
                let nextToastContainer = toastContainerWalker.nextNode();
                if (!nextToastContainer) {
                    toastContainerWalker.currentNode = el;
                    nextToastContainer = toastContainerWalker.nextNode();
                }
                if ((0, _reactutilities.isHTMLElement)(nextToastContainer)) {
                    nextToastContainer.focus();
                }
            }
            if (key === _keyboardkeys.ArrowUp) {
                toastContainerWalker.currentNode = target;
                let prevToastContainer = toastContainerWalker.previousNode();
                if (prevToastContainer && prevToastContainer.contains(target)) {
                    prevToastContainer = toastContainerWalker.previousNode();
                }
                if (!prevToastContainer) {
                    toastContainerWalker.currentNode = el;
                    prevToastContainer = toastContainerWalker.lastChild();
                }
                if ((0, _reactutilities.isHTMLElement)(prevToastContainer)) {
                    prevToastContainer.focus();
                }
            }
        };
        const focusInListener = (e)=>{
            if ((0, _reactutilities.isHTMLElement)(e.currentTarget) && !e.currentTarget.contains((0, _reactutilities.isHTMLElement)(e.relatedTarget) ? e.relatedTarget : null)) {
                pauseAllToasts();
            }
        };
        const focusOutListener = (e)=>{
            if ((0, _reactutilities.isHTMLElement)(e.currentTarget) && !e.currentTarget.contains((0, _reactutilities.isHTMLElement)(e.relatedTarget) ? e.relatedTarget : null)) {
                playAllToasts();
            }
        };
        el.addEventListener('keydown', keydownListener);
        el.addEventListener('focusin', focusInListener);
        el.addEventListener('focusout', focusOutListener);
        cleanupListenersRef.current = ()=>{
            el.removeEventListener('keydown', keydownListener);
            el.removeEventListener('focusin', focusInListener);
            el.removeEventListener('focusout', focusOutListener);
        };
    }, [
        targetDocument,
        pauseAllToasts,
        playAllToasts
    ]);
}
