'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useToastAnnounce", {
    enumerable: true,
    get: function() {
        return useToastAnnounce;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
function useToastAnnounce(announce) {
    const activeRef = _react.useRef(true);
    const cleanupRef = _react.useRef(()=>undefined);
    const announceToast = _react.useCallback((message, options)=>{
        if (activeRef.current) {
            announce(message, options);
        }
    }, [
        announce
    ]);
    const toasterRef = _react.useCallback((el)=>{
        if (!el) {
            cleanupRef.current();
            return;
        }
        const onFocusIn = (e)=>{
            if ((0, _reactutilities.isHTMLElement)(e.currentTarget) && e.currentTarget.contains((0, _reactutilities.isHTMLElement)(e.relatedTarget) ? e.relatedTarget : null)) {
                return;
            }
            activeRef.current = false;
        };
        const onFocusOut = (e)=>{
            if ((0, _reactutilities.isHTMLElement)(e.currentTarget) && e.currentTarget.contains((0, _reactutilities.isHTMLElement)(e.relatedTarget) ? e.relatedTarget : null)) {
                return;
            }
            activeRef.current = true;
        };
        el.addEventListener('focusin', onFocusIn);
        el.addEventListener('focusout', onFocusOut);
        cleanupRef.current = ()=>{
            el.removeEventListener('focusin', onFocusIn);
            el.removeEventListener('focusout', onFocusOut);
        };
    }, []);
    return {
        announceToast,
        toasterRef
    };
}
