'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useToastTrigger_unstable", {
    enumerable: true,
    get: function() {
        return useToastTrigger_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactaria = require("@fluentui/react-aria");
const _toastContainerContext = require("../../contexts/toastContainerContext");
const useToastTrigger_unstable = (props)=>{
    const { children, disableButtonEnhancement = false } = props;
    const { close } = (0, _toastContainerContext.useToastContainerContext)();
    const child = (0, _reactutilities.getTriggerChild)(children);
    const handleClick = (0, _reactutilities.useEventCallback)((e)=>{
        var _child_props_onClick, _child_props;
        child === null || child === void 0 ? void 0 : (_child_props_onClick = (_child_props = child.props).onClick) === null || _child_props_onClick === void 0 ? void 0 : _child_props_onClick.call(_child_props, e);
        if (!e.isDefaultPrevented()) {
            close();
        }
    });
    const triggerChildProps = {
        ...child === null || child === void 0 ? void 0 : child.props,
        ref: (0, _reactutilities.getReactElementRef)(child),
        onClick: handleClick
    };
    const ariaButtonTriggerChildProps = (0, _reactaria.useARIAButtonProps)((child === null || child === void 0 ? void 0 : child.type) === 'button' || (child === null || child === void 0 ? void 0 : child.type) === 'a' ? child.type : 'div', {
        ...triggerChildProps,
        type: 'button'
    });
    return {
        children: (0, _reactutilities.applyTriggerPropsToChildren)(children, disableButtonEnhancement ? triggerChildProps : ariaButtonTriggerChildProps)
    };
};
