'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    toastTitleClassNames: function() {
        return toastTitleClassNames;
    },
    useToastTitleStyles_unstable: function() {
        return useToastTitleStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const toastTitleClassNames = {
    root: 'fui-ToastTitle',
    media: 'fui-ToastTitle__media',
    action: 'fui-ToastTitle__action'
};
const useRootBaseClassName = (0, _react.makeResetStyles)({
    display: 'flex',
    gridColumnEnd: 3,
    color: _reacttheme.tokens.colorNeutralForeground1,
    wordBreak: 'break-word'
});
const useMediaBaseClassName = (0, _react.makeResetStyles)({
    display: 'flex',
    paddingTop: '2px',
    gridColumnEnd: 2,
    paddingRight: '8px',
    fontSize: '16px',
    color: _reacttheme.tokens.colorNeutralForeground1
});
const useActionBaseClassName = (0, _react.makeResetStyles)({
    display: 'flex',
    alignItems: 'start',
    paddingLeft: '12px',
    gridColumnEnd: -1,
    color: _reacttheme.tokens.colorBrandForeground1
});
const useInvertedStyles = (0, _react.makeStyles)({
    root: {
        color: _reacttheme.tokens.colorNeutralForegroundInverted2
    },
    action: {
        color: _reacttheme.tokens.colorBrandForegroundInverted
    },
    media: {
        color: _reacttheme.tokens.colorNeutralForegroundInverted
    }
});
const useIntentIconStyles = (0, _react.makeStyles)({
    success: {
        color: _reacttheme.tokens.colorStatusSuccessForeground1
    },
    error: {
        color: _reacttheme.tokens.colorStatusDangerForeground1
    },
    warning: {
        color: _reacttheme.tokens.colorStatusWarningForeground1
    },
    info: {
        color: _reacttheme.tokens.colorNeutralForeground2
    }
});
const useIntentIconStylesInverted = (0, _react.makeStyles)({
    success: {
        color: _reacttheme.tokens.colorStatusSuccessForegroundInverted
    },
    error: {
        color: _reacttheme.tokens.colorStatusDangerForegroundInverted
    },
    warning: {
        color: _reacttheme.tokens.colorStatusWarningForegroundInverted
    },
    info: {
        color: _reacttheme.tokens.colorNeutralForegroundInverted2
    }
});
const useToastTitleStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    const actionBaseClassName = useActionBaseClassName();
    const mediaBaseClassName = useMediaBaseClassName();
    const intentIconStyles = useIntentIconStyles();
    const intentIconStylesInverted = useIntentIconStylesInverted();
    const { intent } = state;
    const invertedStyles = useInvertedStyles();
    state.root.className = (0, _react.mergeClasses)(toastTitleClassNames.root, rootBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.root, state.root.className);
    if (state.media) {
        state.media.className = (0, _react.mergeClasses)(toastTitleClassNames.media, mediaBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.media, intent && intentIconStyles[intent], intent && state.backgroundAppearance === 'inverted' && intentIconStylesInverted[intent], state.media.className);
    }
    if (state.action) {
        state.action.className = (0, _react.mergeClasses)(toastTitleClassNames.action, actionBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.action, state.action.className);
    }
    return state;
};
