'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    toastTitleClassNames: function() {
        return toastTitleClassNames;
    },
    useToastTitleStyles_unstable: function() {
        return useToastTitleStyles_unstable;
    }
});
const _react = require("@griffel/react");
const toastTitleClassNames = {
    root: 'fui-ToastTitle',
    media: 'fui-ToastTitle__media',
    action: 'fui-ToastTitle__action'
};
const useRootBaseClassName = /*#__PURE__*/ (0, _react.__resetStyles)("rdjap1e", null, [
    ".rdjap1e{display:flex;grid-column-end:3;color:var(--colorNeutralForeground1);word-break:break-word;}"
]);
const useMediaBaseClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r8x5mrd", "r1soj19y", [
    ".r8x5mrd{display:flex;padding-top:2px;grid-column-end:2;padding-right:8px;font-size:16px;color:var(--colorNeutralForeground1);}",
    ".r1soj19y{display:flex;padding-top:2px;grid-column-end:2;padding-left:8px;font-size:16px;color:var(--colorNeutralForeground1);}"
]);
const useActionBaseClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r2j19ip", "rjfozdo", [
    ".r2j19ip{display:flex;align-items:start;padding-left:12px;grid-column-end:-1;color:var(--colorBrandForeground1);}",
    ".rjfozdo{display:flex;align-items:start;padding-right:12px;grid-column-end:-1;color:var(--colorBrandForeground1);}"
]);
const useInvertedStyles = /*#__PURE__*/ (0, _react.__styles)({
    root: {
        sj55zd: "f1w7i9ko"
    },
    action: {
        sj55zd: "f1qz2gb0"
    },
    media: {
        sj55zd: "fqpbvvt"
    }
}, {
    d: [
        ".f1w7i9ko{color:var(--colorNeutralForegroundInverted2);}",
        ".f1qz2gb0{color:var(--colorBrandForegroundInverted);}",
        ".fqpbvvt{color:var(--colorNeutralForegroundInverted);}"
    ]
});
const useIntentIconStyles = /*#__PURE__*/ (0, _react.__styles)({
    success: {
        sj55zd: "f36rra6"
    },
    error: {
        sj55zd: "f1ca9wz"
    },
    warning: {
        sj55zd: "f13isgzr"
    },
    info: {
        sj55zd: "fkfq4zb"
    }
}, {
    d: [
        ".f36rra6{color:var(--colorStatusSuccessForeground1);}",
        ".f1ca9wz{color:var(--colorStatusDangerForeground1);}",
        ".f13isgzr{color:var(--colorStatusWarningForeground1);}",
        ".fkfq4zb{color:var(--colorNeutralForeground2);}"
    ]
});
const useIntentIconStylesInverted = /*#__PURE__*/ (0, _react.__styles)({
    success: {
        sj55zd: "ff3wk4x"
    },
    error: {
        sj55zd: "fbq2gqr"
    },
    warning: {
        sj55zd: "fx6hq1t"
    },
    info: {
        sj55zd: "f1w7i9ko"
    }
}, {
    d: [
        ".ff3wk4x{color:var(--colorStatusSuccessForegroundInverted);}",
        ".fbq2gqr{color:var(--colorStatusDangerForegroundInverted);}",
        ".fx6hq1t{color:var(--colorStatusWarningForegroundInverted);}",
        ".f1w7i9ko{color:var(--colorNeutralForegroundInverted2);}"
    ]
});
const useToastTitleStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    const actionBaseClassName = useActionBaseClassName();
    const mediaBaseClassName = useMediaBaseClassName();
    const intentIconStyles = useIntentIconStyles();
    const intentIconStylesInverted = useIntentIconStylesInverted();
    const { intent } = state;
    const invertedStyles = useInvertedStyles();
    state.root.className = (0, _react.mergeClasses)(toastTitleClassNames.root, rootBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.root, state.root.className);
    if (state.media) {
        state.media.className = (0, _react.mergeClasses)(toastTitleClassNames.media, mediaBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.media, intent && intentIconStyles[intent], intent && state.backgroundAppearance === 'inverted' && intentIconStylesInverted[intent], state.media.className);
    }
    if (state.action) {
        state.action.className = (0, _react.mergeClasses)(toastTitleClassNames.action, actionBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.action, state.action.className);
    }
    return state;
};
