'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    toastFooterClassNames: function() {
        return toastFooterClassNames;
    },
    useToastFooterStyles_unstable: function() {
        return useToastFooterStyles_unstable;
    }
});
const _react = require("@griffel/react");
const toastFooterClassNames = {
    root: 'fui-ToastFooter'
};
/**
 * Styles for the root slot
 */ const useRootBaseClassName = (0, _react.makeResetStyles)({
    paddingTop: '16px',
    gridColumnStart: 2,
    gridColumnEnd: 3,
    display: 'flex',
    alignItems: 'center',
    gap: '14px'
});
const useToastFooterStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    state.root.className = (0, _react.mergeClasses)(toastFooterClassNames.root, rootBaseClassName, state.root.className);
    return state;
};
