'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    toastContainerClassNames: function() {
        return toastContainerClassNames;
    },
    useToastContainerStyles_unstable: function() {
        return useToastContainerStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const toastContainerClassNames = {
    root: 'fui-ToastContainer',
    timer: 'fui-ToastContainer__timer'
};
const useRootBaseClassName = (0, _react.makeResetStyles)({
    boxSizing: 'border-box',
    marginTop: '16px',
    pointerEvents: 'all',
    borderRadius: _reacttheme.tokens.borderRadiusMedium,
    ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
        outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`
    })
});
const useToastContainerStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    state.root.className = (0, _react.mergeClasses)(toastContainerClassNames.root, rootBaseClassName, state.root.className);
    return state;
};
