'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useToastContainer_unstable", {
    enumerable: true,
    get: function() {
        return useToastContainer_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _reacttabster = require("@fluentui/react-tabster");
const _Timer = require("../Timer/Timer");
const intentPolitenessMap = {
    success: 'assertive',
    warning: 'assertive',
    error: 'assertive',
    info: 'polite'
};
const useToastContainer_unstable = (props, ref)=>{
    const { visible, children, close: closeProp, remove, updateId, announce, data, timeout: timerTimeout, politeness: desiredPoliteness, intent = 'info', pauseOnHover, pauseOnWindowBlur, imperativeRef, tryRestoreFocus, content: _content, ...rest } = props;
    const titleId = (0, _reactutilities.useId)('toast-title');
    const bodyId = (0, _reactutilities.useId)('toast-body');
    const toastRef = _react.useRef(null);
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const [running, setRunning] = _react.useState(false);
    const imperativePauseRef = _react.useRef(false);
    const focusedToastBeforeClose = _react.useRef(false);
    const focusableGroupAttribute = (0, _reacttabster.useFocusableGroup)({
        tabBehavior: 'limited-trap-focus',
        // Users should only use Tab to focus into the toast
        // Escape is already reserved to dismiss all toasts
        ignoreDefaultKeydown: {
            Tab: true,
            Escape: true,
            Enter: true
        }
    });
    const close = (0, _reactutilities.useEventCallback)(()=>{
        var _toastRef_current;
        const activeElement = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.activeElement;
        if (activeElement && ((_toastRef_current = toastRef.current) === null || _toastRef_current === void 0 ? void 0 : _toastRef_current.contains(activeElement))) {
            focusedToastBeforeClose.current = true;
        }
        closeProp();
    });
    const onStatusChange = (0, _reactutilities.useEventCallback)((status)=>{
        var _props_onStatusChange;
        return (_props_onStatusChange = props.onStatusChange) === null || _props_onStatusChange === void 0 ? void 0 : _props_onStatusChange.call(props, null, {
            status,
            ...props
        });
    });
    const pause = (0, _reactutilities.useEventCallback)(()=>setRunning(false));
    const play = (0, _reactutilities.useEventCallback)(()=>{
        var _toastRef_current;
        if (imperativePauseRef.current) {
            return;
        }
        var _targetDocument_activeElement;
        const containsActive = !!((_toastRef_current = toastRef.current) === null || _toastRef_current === void 0 ? void 0 : _toastRef_current.contains((_targetDocument_activeElement = targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.activeElement) !== null && _targetDocument_activeElement !== void 0 ? _targetDocument_activeElement : null));
        if (timerTimeout < 0) {
            setRunning(true);
            return;
        }
        if (!containsActive) {
            setRunning(true);
        }
    });
    _react.useImperativeHandle(imperativeRef, ()=>({
            focus: ()=>{
                if (!toastRef.current) {
                    return;
                }
                toastRef.current.focus();
            },
            play: ()=>{
                imperativePauseRef.current = false;
                play();
            },
            pause: ()=>{
                imperativePauseRef.current = true;
                pause();
            }
        }));
    _react.useEffect(()=>{
        return ()=>onStatusChange('unmounted');
    }, [
        onStatusChange
    ]);
    _react.useEffect(()=>{
        if (!targetDocument) {
            return;
        }
        if (pauseOnWindowBlur) {
            var _targetDocument_defaultView, _targetDocument_defaultView1;
            (_targetDocument_defaultView = targetDocument.defaultView) === null || _targetDocument_defaultView === void 0 ? void 0 : _targetDocument_defaultView.addEventListener('focus', play);
            (_targetDocument_defaultView1 = targetDocument.defaultView) === null || _targetDocument_defaultView1 === void 0 ? void 0 : _targetDocument_defaultView1.addEventListener('blur', pause);
            return ()=>{
                var _targetDocument_defaultView, _targetDocument_defaultView1;
                (_targetDocument_defaultView = targetDocument.defaultView) === null || _targetDocument_defaultView === void 0 ? void 0 : _targetDocument_defaultView.removeEventListener('focus', play);
                (_targetDocument_defaultView1 = targetDocument.defaultView) === null || _targetDocument_defaultView1 === void 0 ? void 0 : _targetDocument_defaultView1.removeEventListener('blur', pause);
            };
        }
    }, [
        targetDocument,
        pause,
        play,
        pauseOnWindowBlur
    ]);
    // Users never actually use ToastContainer as a JSX but imperatively through useToastContainerController
    const userRootSlot = data.root;
    const onMotionFinish = _react.useCallback((_, { direction })=>{
        if (direction === 'exit') {
            remove();
        }
        if (direction === 'enter') {
            // start toast once it's fully animated in
            play();
            onStatusChange('visible');
        }
    }, [
        onStatusChange,
        play,
        remove
    ]);
    const onMouseEnter = (0, _reactutilities.useEventCallback)((e)=>{
        var _userRootSlot_onMouseEnter;
        pause();
        userRootSlot === null || userRootSlot === void 0 ? void 0 : (_userRootSlot_onMouseEnter = userRootSlot.onMouseEnter) === null || _userRootSlot_onMouseEnter === void 0 ? void 0 : _userRootSlot_onMouseEnter.call(userRootSlot, e);
    });
    const onMouseLeave = (0, _reactutilities.useEventCallback)((e)=>{
        var _userRootSlot_onMouseEnter;
        play();
        userRootSlot === null || userRootSlot === void 0 ? void 0 : (_userRootSlot_onMouseEnter = userRootSlot.onMouseEnter) === null || _userRootSlot_onMouseEnter === void 0 ? void 0 : _userRootSlot_onMouseEnter.call(userRootSlot, e);
    });
    const { findFirstFocusable, findLastFocusable } = (0, _reacttabster.useFocusFinders)();
    const onKeyDown = (0, _reactutilities.useEventCallback)((e)=>{
        var _userRootSlot_onKeyDown;
        if (e.key === _keyboardkeys.Delete) {
            e.preventDefault();
            close();
        }
        if (e.key === _keyboardkeys.Tab && e.currentTarget === e.target) {
            e.preventDefault();
            if (e.shiftKey) {
                var _findLastFocusable;
                (_findLastFocusable = findLastFocusable(e.currentTarget)) === null || _findLastFocusable === void 0 ? void 0 : _findLastFocusable.focus();
            } else {
                var _findFirstFocusable;
                (_findFirstFocusable = findFirstFocusable(e.currentTarget)) === null || _findFirstFocusable === void 0 ? void 0 : _findFirstFocusable.focus();
            }
        }
        userRootSlot === null || userRootSlot === void 0 ? void 0 : (_userRootSlot_onKeyDown = userRootSlot.onKeyDown) === null || _userRootSlot_onKeyDown === void 0 ? void 0 : _userRootSlot_onKeyDown.call(userRootSlot, e);
    });
    _react.useEffect(()=>{
        var _toastRef_current;
        if (!visible) {
            return;
        }
        const politeness = desiredPoliteness !== null && desiredPoliteness !== void 0 ? desiredPoliteness : intentPolitenessMap[intent];
        var _toastRef_current_textContent;
        announce((_toastRef_current_textContent = (_toastRef_current = toastRef.current) === null || _toastRef_current === void 0 ? void 0 : _toastRef_current.textContent) !== null && _toastRef_current_textContent !== void 0 ? _toastRef_current_textContent : '', {
            politeness
        });
    }, [
        announce,
        desiredPoliteness,
        toastRef,
        visible,
        updateId,
        intent
    ]);
    _react.useEffect(()=>{
        return ()=>{
            if (focusedToastBeforeClose.current) {
                focusedToastBeforeClose.current = false;
                tryRestoreFocus();
            }
        };
    }, [
        tryRestoreFocus
    ]);
    return {
        components: {
            timer: _Timer.Timer,
            root: 'div'
        },
        timer: _reactutilities.slot.always({
            onTimeout: close,
            running,
            timeout: timerTimeout !== null && timerTimeout !== void 0 ? timerTimeout : -1
        }, {
            elementType: _Timer.Timer
        }),
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, toastRef),
            children,
            tabIndex: 0,
            role: 'listitem',
            'aria-labelledby': titleId,
            'aria-describedby': bodyId,
            ...rest,
            ...userRootSlot,
            ...focusableGroupAttribute,
            onMouseEnter,
            onMouseLeave,
            onKeyDown
        }), {
            elementType: 'div'
        }),
        timerTimeout,
        transitionTimeout: 0,
        running,
        visible,
        remove,
        close,
        onTransitionEntering: ()=>{
        /* no-op */ },
        updateId,
        nodeRef: toastRef,
        intent,
        titleId,
        bodyId,
        onMotionFinish
    };
};
