'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    toastBodyClassNames: function() {
        return toastBodyClassNames;
    },
    useToastBodyStyles_unstable: function() {
        return useToastBodyStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const toastBodyClassNames = {
    root: 'fui-ToastBody',
    subtitle: 'fui-ToastBody__subtitle'
};
const useRootBaseClassName = (0, _react.makeResetStyles)({
    gridColumnStart: 2,
    gridColumnEnd: 3,
    paddingTop: '6px',
    fontSize: _reacttheme.tokens.fontSizeBase300,
    lineHeight: _reacttheme.tokens.lineHeightBase300,
    fontWeight: _reacttheme.tokens.fontWeightRegular,
    color: _reacttheme.tokens.colorNeutralForeground1,
    wordBreak: 'break-word'
});
const useSubtitleBaseClassName = (0, _react.makeResetStyles)({
    paddingTop: '4px',
    gridColumnStart: 2,
    gridColumnEnd: 3,
    fontSize: _reacttheme.tokens.fontSizeBase200,
    lineHeight: _reacttheme.tokens.fontSizeBase200,
    fontWeight: _reacttheme.tokens.fontWeightRegular,
    color: _reacttheme.tokens.colorNeutralForeground2
});
const useInvertedStyles = (0, _react.makeStyles)({
    root: {
        color: _reacttheme.tokens.colorNeutralForegroundInverted2
    },
    subtitle: {
        color: _reacttheme.tokens.colorNeutralForegroundInverted2
    }
});
const useToastBodyStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    const subtitleBaseClassName = useSubtitleBaseClassName();
    const invertedStyles = useInvertedStyles();
    state.root.className = (0, _react.mergeClasses)(toastBodyClassNames.root, rootBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.root, state.root.className);
    if (state.subtitle) {
        state.subtitle.className = (0, _react.mergeClasses)(toastBodyClassNames.subtitle, subtitleBaseClassName, state.backgroundAppearance === 'inverted' && invertedStyles.subtitle, state.subtitle.className);
    }
    return state;
};
