'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    toastClassNames: function() {
        return toastClassNames;
    },
    useToastStyles_unstable: function() {
        return useToastStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const toastClassNames = {
    root: 'fui-Toast'
};
const useRootBaseClassName = (0, _react.makeResetStyles)({
    display: 'grid',
    gridTemplateColumns: 'auto 1fr auto',
    padding: '12px',
    borderRadius: _reacttheme.tokens.borderRadiusMedium,
    border: `1px solid ${_reacttheme.tokens.colorTransparentStroke}`,
    boxShadow: _reacttheme.tokens.shadow8,
    fontSize: _reacttheme.tokens.fontSizeBase300,
    lineHeight: '20px',
    fontWeight: _reacttheme.tokens.fontWeightSemibold,
    color: _reacttheme.tokens.colorNeutralForeground1,
    backgroundColor: _reacttheme.tokens.colorNeutralBackground1
});
const useStyles = (0, _react.makeStyles)({
    inverted: {
        color: _reacttheme.tokens.colorNeutralForegroundInverted2,
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundInverted
    }
});
const useToastStyles_unstable = (state)=>{
    'use no memo';
    const rootBaseClassName = useRootBaseClassName();
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(toastClassNames.root, rootBaseClassName, state.backgroundAppearance === 'inverted' && styles.inverted, state.root.className);
    return state;
};
