'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "Timer", {
    enumerable: true,
    get: function() {
        return Timer;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useTimerStylesstyles = require("./useTimerStyles.styles");
const Timer = /*#__PURE__*/ _react.forwardRef((props, ref)=>{
    const baseAnimationStyles = (0, _useTimerStylesstyles.useBaseAnimationStyles)();
    const { running, timeout, onTimeout } = props;
    const style = {
        animationDuration: `${timeout}ms`,
        animationPlayState: running ? 'running' : 'paused'
    };
    if (timeout < 0) {
        return null;
    }
    return /*#__PURE__*/ _react.createElement("span", {
        onAnimationEnd: onTimeout,
        "data-timer-status": style.animationPlayState,
        ref: ref,
        style: style,
        className: baseAnimationStyles
    });
});
Timer.displayName = 'Timer';
