'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useAriaLive_unstable", {
    enumerable: true,
    get: function() {
        return useAriaLive_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
/** The duration the message needs to be in present in DOM for screen readers to register a change and announce */ const MESSAGE_DURATION = 500;
const useAriaLive_unstable = (props)=>{
    const [currentMessage, setCurrentMessage] = _react.useState(undefined);
    // Can't rely on Date.now() if user invokes announce more than once in a code block
    const order = _react.useRef(0);
    const [messageQueue] = _react.useState(()=>(0, _reactutilities.createPriorityQueue)((a, b)=>{
            if (a.politeness === b.politeness) {
                return a.createdAt - b.createdAt;
            }
            return a.politeness === 'assertive' ? -1 : 1;
        }));
    const announce = (0, _reactutilities.useEventCallback)((message, options)=>{
        const { politeness } = options;
        if (message === (currentMessage === null || currentMessage === void 0 ? void 0 : currentMessage.message)) {
            return;
        }
        const liveMessage = {
            message,
            politeness,
            createdAt: order.current++
        };
        if (!currentMessage) {
            setCurrentMessage(liveMessage);
        } else {
            messageQueue.enqueue(liveMessage);
        }
    });
    const [setMessageTimeout, clearMessageTimeout] = (0, _reactutilities.useTimeout)();
    _react.useEffect(()=>{
        setMessageTimeout(()=>{
            if (messageQueue.peek()) {
                setCurrentMessage(messageQueue.dequeue());
            } else {
                setCurrentMessage(undefined);
            }
        }, MESSAGE_DURATION);
        return ()=>clearMessageTimeout();
    }, [
        currentMessage,
        messageQueue,
        setMessageTimeout,
        clearMessageTimeout
    ]);
    _react.useImperativeHandle(props.announceRef, ()=>announce);
    const politeMessage = (currentMessage === null || currentMessage === void 0 ? void 0 : currentMessage.politeness) === 'polite' ? currentMessage.message : undefined;
    const assertiveMessage = (currentMessage === null || currentMessage === void 0 ? void 0 : currentMessage.politeness) === 'assertive' ? currentMessage.message : undefined;
    return {
        components: {
            assertive: 'div',
            polite: 'div'
        },
        assertive: _reactutilities.slot.always(props.assertive, {
            defaultProps: {
                'aria-live': 'assertive',
                children: assertiveMessage
            },
            elementType: 'div'
        }),
        polite: _reactutilities.slot.always(props.polite, {
            defaultProps: {
                'aria-live': 'polite',
                children: politeMessage
            },
            elementType: 'div'
        })
    };
};
