import { ARIAButtonResultProps } from '@fluentui/react-aria';
import { ARIAButtonType } from '@fluentui/react-aria';
import { BackgroundAppearanceContextValue } from '@fluentui/react-shared-contexts';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import type { PortalProps } from '@fluentui/react-portal';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';
import type { TriggerProps } from '@fluentui/react-utilities';

declare type Announce = (message: string, options: AnnounceOptions) => void;

declare type AnnounceOptions = {
    politeness: AriaLivePoliteness;
};

declare type AriaLivePoliteness = 'polite' | 'assertive';

/**
 * AriaLive Props
 */
declare type AriaLiveProps = ComponentProps<Partial<AriaLiveSlots>> & {
    announceRef: React_2.Ref<Announce>;
    children?: React_2.ReactNode;
};

declare type AriaLiveSlots = {
    assertive: NonNullable<Slot<'div'>>;
    polite: NonNullable<Slot<'div'>>;
};

declare interface CommonToastDetail {
    toasterId?: ToasterId;
}

declare interface DispatchToastOptions extends Partial<Omit<ToastOptions, 'toasterId'>> {
    root?: RootSlot;
}

/**
 * Render the final JSX of Toast
 */
export declare const renderToast_unstable: (state: ToastState, contextValues: ToastContextValues) => JSXElement;

/**
 * Render the final JSX of ToastBody
 */
export declare const renderToastBody_unstable: (state: ToastBodyState) => JSXElement;

/**
 * Render the final JSX of Toaster
 */
export declare const renderToaster_unstable: (state: ToasterState) => JSXElement;

/**
 * Render the final JSX of ToastFooter
 */
export declare const renderToastFooter_unstable: (state: ToastFooterState) => JSXElement;

/**
 * Render the final JSX of ToastTitle
 */
export declare const renderToastTitle_unstable: (state: ToastTitleState) => JSXElement;

/**
 * Render the final JSX of MenuTrigger
 *
 * Only renders children
 */
export declare const renderToastTrigger_unstable: (state: ToastTriggerState) => JSXElement | null;

declare type RootSlot = Slot<'div'>;

declare type TimerProps = {
    running: boolean;
    timeout: number;
    onTimeout: () => void;
    as?: 'span';
};

/**
 * Toast component
 */
export declare const Toast: ForwardRefComponent<ToastProps>;

declare interface Toast_2<TData = object> extends ToastOptions<TData> {
    /**
     * Determines the visiblity of a toast
     */
    close: () => void;
    /**
     * Removes a toast completely
     */
    remove: () => void;
    /**
     * A number used to track updates immutably
     */
    updateId: number;
    /**
     * Used to determine default priority when the user does not set one
     * Simple counter of toasts dispatched.
     */
    order: number;
    imperativeRef: React_2.RefObject<ToastImperativeRef | null>;
}

/**
 * ToastBody component
 */
export declare const ToastBody: ForwardRefComponent<ToastBodyProps>;

export declare const toastBodyClassNames: SlotClassNames<ToastBodySlots>;

/**
 * ToastBody Props
 */
export declare type ToastBodyProps = ComponentProps<ToastBodySlots> & {};

export declare type ToastBodySlots = {
    root: Slot<'div'>;
    subtitle?: Slot<'div'>;
};

/**
 * State used in rendering ToastBody
 */
export declare type ToastBodyState = ComponentState<ToastBodySlots> & {
    backgroundAppearance: BackgroundAppearanceContextValue;
};

declare interface ToastChangeData extends ToastOptions, Pick<Toast_2, 'updateId'> {
    status: ToastStatus;
}

declare type ToastChangeHandler = (event: null, data: ToastChangeData) => void;

export declare const toastClassNames: SlotClassNames<ToastSlots>;

export declare const toastContainerClassNames: SlotClassNames<ToastContainerSlots>;

declare type ToastContainerContextValue = {
    close: () => void;
    intent: ToastIntent | undefined;
    bodyId: string;
    titleId: string;
};

/**
 * ToastContainer Props
 */
declare type ToastContainerProps = Omit<ComponentProps<Partial<ToastContainerSlots>>, 'content'> & Toast_2 & {
    visible: boolean;
    announce: Announce;
    intent: ToastIntent | undefined;
    tryRestoreFocus: () => void;
};

declare type ToastContainerSlots = {
    root: NonNullable<Slot<'div'>>;
    timer: NonNullable<Slot<TimerProps>>;
};

/**
 * State used in rendering ToastContainer
 */
export declare type ToastContainerState = ComponentState<ToastContainerSlots> & Pick<ToastContainerProps, 'remove' | 'close' | 'updateId' | 'visible' | 'intent'> & Pick<ToastContainerContextValue, 'titleId' | 'bodyId'> & {
    /**
     * @deprecated Will be always "0".
     */
    transitionTimeout: number;
    timerTimeout: number;
    running: boolean;
    /**
     * @deprecated Will be always no-op.
     */
    onTransitionEntering: () => void;
    /**
     * @deprecated now merged with root ref
     */
    nodeRef: React_2.Ref<HTMLDivElement>;
    onMotionFinish?: (event: null, data: {
        direction: 'enter' | 'exit';
    }) => void;
};

declare type ToastContextValues = {
    backgroundAppearance: BackgroundAppearanceContextValue;
};

/**
 * Toaster component - renders a collection of toasts dispatched imperatively
 */
export declare const Toaster: React_2.FC<ToasterProps>;

export declare const toasterClassNames: SlotClassNames<ToasterSlots>;

declare type ToasterId = string;

declare interface ToasterOptions extends Pick<ToastOptions, 'position' | 'timeout' | 'pauseOnWindowBlur' | 'pauseOnHover' | 'priority'> {
    offset?: ToastOffset;
    toasterId?: ToasterId;
    limit?: number;
    shortcuts?: ToasterShortcuts;
}

/**
 * Toaster Props
 */
export declare type ToasterProps = Omit<ComponentProps<ToasterSlots>, 'children'> & Partial<ToasterOptions> & Pick<PortalProps, 'mountNode'> & {
    /**
     * User override API for aria-live narration for toasts
     */
    announce?: Announce;
    inline?: boolean;
};

declare interface ToasterShortcuts {
    focus: (e: KeyboardEvent) => boolean;
}

export declare type ToasterSlots = {
    /**
     * NOTE: This root slot maps in exactly the same way to the containers rendered for each toast position
     * There is no intention (currently) to let users customize the div for each toast position.
     */
    root: Slot<'div'>;
};

declare type ToasterSlotsInternal = ToasterSlots & {
    bottomEnd?: Slot<'div'>;
    bottomStart?: Slot<'div'>;
    topEnd?: Slot<'div'>;
    topStart?: Slot<'div'>;
    top?: Slot<'div'>;
    bottom?: Slot<'div'>;
};

/**
 * State used in rendering Toaster
 */
export declare type ToasterState = ComponentState<ToasterSlotsInternal> & Pick<AriaLiveProps, 'announceRef'> & Pick<PortalProps, 'mountNode'> & Pick<Required<ToasterProps>, 'announce' | 'inline'> & {
    offset: ToasterOptions['offset'] | undefined;
    renderAriaLive: boolean;
    dir: 'rtl' | 'ltr';
};

/**
 * ToastFooter component
 */
export declare const ToastFooter: ForwardRefComponent<ToastFooterProps>;

export declare const toastFooterClassNames: SlotClassNames<ToastFooterSlots>;

/**
 * ToastFooter Props
 */
export declare type ToastFooterProps = ComponentProps<ToastFooterSlots> & {};

export declare type ToastFooterSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering ToastFooter
 */
export declare type ToastFooterState = ComponentState<ToastFooterSlots>;

export declare type ToastId = string;

declare type ToastImperativeRef = {
    /**
     * Focuses the Toast.
     * If there are no focusable elements in the Toast, the Toast itself is focused.
     */
    focus: () => void;
    /**
     * Resumes the timeout of a paused toast
     */
    play: () => void;
    /**
     * Pauses the timeout of a toast
     */
    pause: () => void;
};

export declare type ToastIntent = 'info' | 'success' | 'error' | 'warning';

export declare type ToastOffset = Partial<Record<ToastPosition, ToastOffsetObject>> | ToastOffsetObject;

declare interface ToastOffsetObject {
    horizontal?: number;
    vertical?: number;
}

declare interface ToastOptions<TData = object> {
    /**
     * Uniquely identifies a toast, used for update and dismiss operations
     */
    toastId: ToastId;
    /**
     * The position the toast should render to
     */
    position: ToastPosition;
    /**
     * Toast content
     */
    content: unknown;
    /**
     * Auto dismiss timeout in milliseconds
     * @default 3000
     */
    timeout: number;
    /**
     * Toast timeout pauses while focus is on another window
     * @default false
     */
    pauseOnWindowBlur: boolean;
    /**
     * Toast timeout pauses while user cursor is on the toast
     * @default false
     */
    pauseOnHover: boolean;
    /**
     * Toast belongs to a specific toaster
     */
    toasterId: ToasterId | undefined;
    /**
     * Higher priority toasts will be rendered before lower priority toasts
     */
    priority: number;
    /**
     * Used to determine [aria-live](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions) narration
     * This will override the intent prop
     */
    politeness?: ToastPoliteness;
    /**
     * Default toast types that determine the urgency or [aria-live](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions) narration
     * The UI layer may use these intents to apply specific styling.
     * @default info
     */
    intent?: ToastIntent;
    /**
     * Additional data that needs to be passed to the toast
     */
    data: TData;
    /**
     * Reports changes to the Toast lifecycle
     */
    onStatusChange: ToastChangeHandler | undefined;
}

export declare type ToastPoliteness = 'assertive' | 'polite';

export declare type ToastPosition = 'top-end' | 'top-start' | 'bottom-end' | 'bottom-start' | 'top' | 'bottom';

/**
 * Toast Props
 */
export declare type ToastProps = ComponentProps<ToastSlots> & {
    appearance?: BackgroundAppearanceContextValue;
};

export declare type ToastSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering Toast
 */
export declare type ToastState = ComponentState<ToastSlots> & {
    backgroundAppearance: BackgroundAppearanceContextValue;
    intent?: ToastIntent | undefined;
};

export declare type ToastStatus = 'queued' | 'visible' | 'dismissed' | 'unmounted';

/**
 * ToastTitle component
 */
export declare const ToastTitle: ForwardRefComponent<ToastTitleProps>;

export declare const toastTitleClassNames: SlotClassNames<ToastTitleSlots>;

/**
 * ToastTitle Props
 */
export declare type ToastTitleProps = ComponentProps<ToastTitleSlots> & {};

export declare type ToastTitleSlots = {
    root: NonNullable<Slot<'div'>>;
    media?: Slot<'div'>;
    action?: Slot<'div'>;
};

/**
 * State used in rendering ToastTitle
 */
export declare type ToastTitleState = ComponentState<ToastTitleSlots> & Pick<ToastContainerContextValue, 'intent'> & {
    backgroundAppearance: BackgroundAppearanceContextValue;
};

/**
 * ToastTrigger component
 */
export declare const ToastTrigger: React_2.FC<ToastTriggerProps>;

/**
 * Props that are passed to the child of the ToastTrigger when cloned to ensure correct behaviour for the Toast
 */
export declare type ToastTriggerChildProps<Type extends ARIAButtonType = ARIAButtonType, Props = {}> = ARIAButtonResultProps<Type, Props>;

export declare type ToastTriggerProps = TriggerProps<ToastTriggerChildProps> & {
    /**
     * Disables internal trigger mechanism that ensures a child provided will be a compliant ARIA button.
     * @default false
     */
    disableButtonEnhancement?: boolean;
};

export declare type ToastTriggerState = {
    children: React_2.ReactElement | null;
};

declare interface UpdateToastEventDetail extends Partial<ToastOptions>, CommonToastDetail {
    toastId: ToastId;
}

declare interface UpdateToastOptions extends UpdateToastEventDetail {
    root?: RootSlot;
}

/**
 * Create the state required to render Toast.
 *
 * The returned state can be modified with hooks such as useToastStyles_unstable,
 * before being passed to renderToast_unstable.
 *
 * @param props - props from this instance of Toast
 * @param ref - reference to root HTMLElement of Toast
 */
export declare const useToast_unstable: (props: ToastProps, ref: React_2.Ref<HTMLElement>) => ToastState;

/**
 * Create the state required to render ToastBody.
 *
 * The returned state can be modified with hooks such as useToastBodyStyles_unstable,
 * before being passed to renderToastBody_unstable.
 *
 * @param props - props from this instance of ToastBody
 * @param ref - reference to root HTMLElement of ToastBody
 */
export declare const useToastBody_unstable: (props: ToastBodyProps, ref: React_2.Ref<HTMLElement>) => ToastBodyState;

/**
 * Apply styling to the ToastBody slots based on the state
 */
export declare const useToastBodyStyles_unstable: (state: ToastBodyState) => ToastBodyState;

/**
 * @param toasterId - If an id is provided all imperative methods control that specific toaster
 * @returns Imperative methods to control toasts
 */
export declare function useToastController(toasterId?: ToasterId): {
    dispatchToast: (content: React_2.ReactNode, options?: DispatchToastOptions) => void;
    dismissToast: (toastId: ToastId) => void;
    dismissAllToasts: () => void;
    updateToast: (options: UpdateToastOptions) => void;
    pauseToast: (toastId: ToastId) => void;
    playToast: (toastId: ToastId) => void;
};

/**
 * Create the state required to render Toaster.
 *
 * @param props - props from this instance of Toaster
 */
export declare const useToaster_unstable: (props: ToasterProps) => ToasterState;

/**
 * Apply styling to the Toaster slots based on the state
 */
export declare const useToasterStyles_unstable: (state: ToasterState) => ToasterState;

/**
 * Create the state required to render ToastFooter.
 *
 * The returned state can be modified with hooks such as useToastFooterStyles_unstable,
 * before being passed to renderToastFooter_unstable.
 *
 * @param props - props from this instance of ToastFooter
 * @param ref - reference to root HTMLElement of ToastFooter
 */
export declare const useToastFooter_unstable: (props: ToastFooterProps, ref: React_2.Ref<HTMLElement>) => ToastFooterState;

/**
 * Apply styling to the ToastFooter slots based on the state
 */
export declare const useToastFooterStyles_unstable: (state: ToastFooterState) => ToastFooterState;

/**
 * Apply styling to the Toast slots based on the state
 */
export declare const useToastStyles_unstable: (state: ToastState) => ToastState;

/**
 * Create the state required to render ToastTitle.
 *
 * The returned state can be modified with hooks such as useToastTitleStyles_unstable,
 * before being passed to renderToastTitle_unstable.
 *
 * @param props - props from this instance of ToastTitle
 * @param ref - reference to root HTMLElement of ToastTitle
 */
export declare const useToastTitle_unstable: (props: ToastTitleProps, ref: React_2.Ref<HTMLElement>) => ToastTitleState;

/**
 * Apply styling to the ToastTitle slots based on the state
 */
export declare const useToastTitleStyles_unstable: (state: ToastTitleState) => ToastTitleState;

/**
 * A non-visual component that wraps its child
 * and configures them to be the trigger that will close a `Toast`.
 * This component should only accept one child.
 *
 * This component sole purpose is to avoid opting out of the internal controlled open state of a `Toast`
 * Besides being a trigger that closes a toast through context this component doesn't do much,
 * making it basically unnecessary in cases where the trigger is outside of a toast.
 */
export declare const useToastTrigger_unstable: (props: ToastTriggerProps) => ToastTriggerState;

export { }
