# @fluentui/react-theme

**React Theme for [Fluent UI React](https://react.fluentui.dev)**

## Usage

Import a theme and tokens:

```jsx
import { webLightTheme, tokens } from '@fluentui/react-components';
```

Pass the theme to the `FluentProvider`:

```jsx
<FluentProvider theme={webLightTheme}>
  <App />
</FluentProvider>
```

Use the `tokens` in your styles:

```jsx
const useStyles = makeStyles({
  root: {
    color: tokens.colorNeutralForeground1,
  },
});
```

### Using a custom brand ramp

To use a theme based on a custom brand ramp, use the `createXXXTheme` function:

```jsx
import { createWebLightTheme } from '@fluentui/react-components';

const customBrandRamp: BrandVariants = {
  10: `#2b2b40`,
  // ...
  160: `#e8ebfa`,
};

const customTheme = createWebLightTheme(customBrandRamp);
```

## Contributing

### Updating colors in the theme

The color tokens are generated by token pipeline. Do not edit colors directly. Instead, update the token pipeline first and once the changes are merged there, run:

```sh
yarn token-pipeline
```

### Adding new color tokens

To add a new color token, besides updating the token pipeline, you also need to update corresponding typings and the `tokens` object in `src/tokens.ts`.

### Updating other tokens

To update any tokens not related to colors, update the values directly in this package.
