'use client';
import * as React from 'react';
import { useFieldControlProps_unstable } from '@fluentui/react-field';
import { getPartitionedNativeProps, useControllableState, useEventCallback, slot } from '@fluentui/react-utilities';
import { useOverrides_unstable as useOverrides } from '@fluentui/react-shared-contexts';
/**
 * Create the state required to render Textarea.
 *
 * The returned state can be modified with hooks such as useTextareaStyles_unstable,
 * before being passed to renderTextarea_unstable.
 *
 * @param props - props from this instance of Textarea
 * @param ref - reference to root HTMLElement of Textarea
 */ export const useTextarea_unstable = (props, ref)=>{
    // Merge props from surrounding <Field>, if any
    props = useFieldControlProps_unstable(props, {
        supportsLabelFor: true,
        supportsRequired: true,
        supportsSize: true
    });
    const overrides = useOverrides();
    var _overrides_inputDefaultAppearance;
    const { size = 'medium', appearance = (_overrides_inputDefaultAppearance = overrides.inputDefaultAppearance) !== null && _overrides_inputDefaultAppearance !== void 0 ? _overrides_inputDefaultAppearance : 'outline', resize = 'none', onChange } = props;
    if (process.env.NODE_ENV !== 'production' && (appearance === 'filled-darker-shadow' || appearance === 'filled-lighter-shadow')) {
        // eslint-disable-next-line no-console
        console.error("The 'filled-darker-shadow' and 'filled-lighter-shadow' appearances are deprecated and will be removed in the" + ' future.');
    }
    const [value, setValue] = useControllableState({
        state: props.value,
        defaultState: props.defaultValue,
        initialState: undefined
    });
    const nativeProps = getPartitionedNativeProps({
        props,
        primarySlotTagName: 'textarea',
        excludedPropNames: [
            'onChange',
            'value',
            'defaultValue'
        ]
    });
    const state = {
        size,
        appearance,
        resize,
        components: {
            root: 'span',
            textarea: 'textarea'
        },
        textarea: slot.always(props.textarea, {
            defaultProps: {
                ref,
                ...nativeProps.primary
            },
            elementType: 'textarea'
        }),
        root: slot.always(props.root, {
            defaultProps: nativeProps.root,
            elementType: 'span'
        })
    };
    state.textarea.value = value;
    state.textarea.onChange = useEventCallback((ev)=>{
        const newValue = ev.target.value;
        onChange === null || onChange === void 0 ? void 0 : onChange(ev, {
            value: newValue
        });
        setValue(newValue);
    });
    return state;
};
