'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    textareaClassNames: function() {
        return textareaClassNames;
    },
    useTextareaStyles_unstable: function() {
        return useTextareaStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const textareaClassNames = {
    root: 'fui-Textarea',
    textarea: 'fui-Textarea__textarea'
};
/**
 * Styles for the root(wrapper) slot
 */ const useRootStyles = (0, _react.makeStyles)({
    base: {
        display: 'inline-flex',
        boxSizing: 'border-box',
        position: 'relative',
        // Padding needed so the focus indicator does not overlap the resize handle, this should match focus indicator size.
        padding: `0 0 ${_reacttheme.tokens.strokeWidthThick} 0`,
        margin: '0',
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        verticalAlign: 'top'
    },
    disabled: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStrokeDisabled}`,
        '@media (forced-colors: active)': {
            ..._react.shorthands.borderColor('GrayText')
        }
    },
    interactive: {
        // This is all for the bottom focus border.
        // It's supposed to be 2px flat all the way across and match the radius of the field's corners.
        '::after': {
            boxSizing: 'border-box',
            content: '""',
            position: 'absolute',
            left: '-1px',
            bottom: '-1px',
            right: '-1px',
            // Maintaining the correct corner radius:
            // Use the whole border-radius as the height and only put radii on the bottom corners.
            // (Otherwise the radius would be automatically reduced to fit available space.)
            // max() ensures the focus border still shows up even if someone sets tokens.borderRadiusMedium to 0.
            height: `max(${_reacttheme.tokens.strokeWidthThick}, ${_reacttheme.tokens.borderRadiusMedium})`,
            borderBottomLeftRadius: _reacttheme.tokens.borderRadiusMedium,
            borderBottomRightRadius: _reacttheme.tokens.borderRadiusMedium,
            // Flat 2px border:
            // By default borderBottom will cause little "horns" on the ends. The clipPath trims them off.
            // (This could be done without trimming using `background: linear-gradient(...)`, but using
            // borderBottom makes it easier for people to override the color if needed.)
            borderBottom: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorCompoundBrandStroke}`,
            clipPath: `inset(calc(100% - ${_reacttheme.tokens.strokeWidthThick}) 0 0 0)`,
            // Animation for focus OUT
            transform: 'scaleX(0)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationUltraFast,
            transitionDelay: _reacttheme.tokens.curveAccelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        ':focus-within::after': {
            // Animation for focus IN
            transform: 'scaleX(1)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationNormal,
            transitionDelay: _reacttheme.tokens.curveDecelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        ':focus-within:active::after': {
            // This is if the user clicks the field again while it's already focused
            borderBottomColor: _reacttheme.tokens.colorCompoundBrandStrokePressed
        },
        ':focus-within': {
            outlineWidth: _reacttheme.tokens.strokeWidthThick,
            outlineStyle: 'solid',
            outlineColor: 'transparent'
        }
    },
    filled: {
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`,
        ':hover,:focus-within': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStrokeInteractive)
        }
    },
    'filled-darker': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3
    },
    'filled-lighter': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1
    },
    'filled-darker-shadow': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStrokeInteractive}`,
        boxShadow: _reacttheme.tokens.shadow2
    },
    'filled-lighter-shadow': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStrokeInteractive}`,
        boxShadow: _reacttheme.tokens.shadow2
    },
    outline: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1}`,
        borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
    },
    outlineInteractive: {
        ':hover': {
            border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1Hover}`,
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
        },
        ':active': {
            border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1Pressed}`,
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        },
        ':focus-within': {
            border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1Pressed}`,
            borderBottomColor: _reacttheme.tokens.colorCompoundBrandStroke
        }
    },
    invalid: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder2)
        }
    }
});
/**
 * Styles for the textarea slot
 */ const useTextareaStyles = (0, _react.makeStyles)({
    base: {
        ..._react.shorthands.borderStyle('none'),
        margin: '0',
        backgroundColor: 'transparent',
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorNeutralForeground1,
        flexGrow: 1,
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        height: '100%',
        '::placeholder': {
            color: _reacttheme.tokens.colorNeutralForeground4,
            opacity: 1
        },
        outlineStyle: 'none'
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        cursor: 'not-allowed',
        '::placeholder': {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        }
    },
    // The padding style adds both content and regular padding (from design spec), this is because the handle is not
    // affected by changing the padding of the root.
    small: {
        minHeight: '40px',
        padding: `${_reacttheme.tokens.spacingVerticalXS} calc(${_reacttheme.tokens.spacingHorizontalSNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`,
        maxHeight: '200px',
        ..._reacttheme.typographyStyles.caption1
    },
    medium: {
        minHeight: '52px',
        padding: `${_reacttheme.tokens.spacingVerticalSNudge} calc(${_reacttheme.tokens.spacingHorizontalMNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`,
        maxHeight: '260px',
        ..._reacttheme.typographyStyles.body1
    },
    large: {
        minHeight: '64px',
        padding: `${_reacttheme.tokens.spacingVerticalS} calc(${_reacttheme.tokens.spacingHorizontalM} + ${_reacttheme.tokens.spacingHorizontalXXS})`,
        maxHeight: '320px',
        ..._reacttheme.typographyStyles.body2
    }
});
/**
 * Styles for the textarea's resize property
 */ const useTextareaResizeStyles = (0, _react.makeStyles)({
    none: {
        resize: 'none'
    },
    both: {
        resize: 'both'
    },
    horizontal: {
        resize: 'horizontal'
    },
    vertical: {
        resize: 'vertical'
    }
});
const useTextareaStyles_unstable = (state)=>{
    'use no memo';
    const { size, appearance, resize } = state;
    const disabled = state.textarea.disabled;
    const invalid = `${state.textarea['aria-invalid']}` === 'true';
    const filled = appearance.startsWith('filled');
    const rootStyles = useRootStyles();
    state.root.className = (0, _react.mergeClasses)(textareaClassNames.root, rootStyles.base, disabled && rootStyles.disabled, !disabled && filled && rootStyles.filled, !disabled && rootStyles[appearance], !disabled && rootStyles.interactive, !disabled && appearance === 'outline' && rootStyles.outlineInteractive, !disabled && invalid && rootStyles.invalid, state.root.className);
    const textareaStyles = useTextareaStyles();
    const textareaResizeStyles = useTextareaResizeStyles();
    state.textarea.className = (0, _react.mergeClasses)(textareaClassNames.textarea, textareaStyles.base, textareaStyles[size], textareaResizeStyles[resize], disabled && textareaStyles.disabled, state.textarea.className);
    return state;
};
